#ifndef FASTA_H
#define FASTA_H


#include <iostream>
using namespace std;

enum fasta_code { fasta_success, fasta_eof, fasta_badheader, NUM_FASTA_CODES };

/** Strings for each code */
const char fasta_message[NUM_FASTA_CODES][256] = 
	{ "Success", "Premature EOF", "Bad header" };


/** skip past a fasta record.  Return true iff a record was skipped (!eof) */
fasta_code fasta_skip(istream &in);

/** remove extraneous characters */
void fasta_trim(string &dna);

/** read a single fasta (header,sequence) pair */
fasta_code fasta_read(istream &in, string &header, string &sequence);


#endif
