
#include "genomic.h"
#include "grid.h"

#include <iostream>
#include <iomanip>
#include <sstream>
using namespace std;

/** True iff all characters in {ACGT} */
bool over_dna(const string &sequence) { 
	for (uint i=0; i<sequence.length(); i++) { 
		if (dna_id(sequence[i]) == DNA_ABLEN) { return false; }
	}
	return true;
}




/** 
 * Return a string that is the DNA/IUPAC complement of the input string
 *	reverse = reverse the ordering of the sequence
 */
string revcomp(const string &sequence, bool reverse) {

	string ans = sequence;	// init to same length

	for (uint i=0; i<sequence.length(); i++) { 
		
		// find number for character
		int p = IUPAC_ALPHABET.find(sequence[i]);
		if (p < 0) { p = iupac_alphabet.find(sequence[i]); }
		if (p < 0) { 
			cerr << "WARNING (dna.revcomp) Illegal IUPAC character '" << sequence[i] << "'" << endl;
			p = 0;	// 0 is 0000
		}

		int c = 0;	// number of complement

		if (p & (1 << DNA_A)) { c |= (1 << DNA_T); }
		if (p & (1 << DNA_C)) { c |= (1 << DNA_G); }
		if (p & (1 << DNA_G)) { c |= (1 << DNA_C); }
		if (p & (1 << DNA_T)) { c |= (1 << DNA_A); }
		
		char x;
		x = ('a' <= sequence[i] && sequence[i] <= 'z') ? iupac_alphabet[c] : IUPAC_ALPHABET[c];	// same base as sequence

		// set the appropriate character, depending on whether or not this is being reversed.
		if (reverse) { 
			ans[sequence.length() - 1 - i] = x;
		} else {
			ans[i] = x;
		}

	}
	return ans;
}

	


