#include <iostream>
#include <fstream>
using namespace std;

#include "Distance.h"
#include "Option.h"


void gnuplot(const Distance &distance, uint N) { 

	// prob
	{
		ofstream data_out("test-Distance.prob.data");
		for (uint x=0; x<distance.size(); x++) { 
			data_out << x << "\t" << distance.prob(x) << endl;
		}
		data_out.close();
	}
	
	// gnuplot CDF
	{
		ofstream data_out("test-Distance.CDF.data");
		for (uint x=0; x<distance.size(); x++) {
			data_out << x << "\t" << distance.CDF(x) << endl;
		}
		data_out.close();
	}

	
	system("echo \"plot [][0:] 'test-Distance.prob.data' title 'prob' with lines\" | gnuplot -persist -noraise");
	system("echo \"plot [][0:1] 'test-Distance.CDF.data' title 'CDF' with lines\" | gnuplot -persist -noraise");

}
			


int main(int argc, char **argv) { 

	uint size;
	uint binw;

	uint N;
	uint seed;
	
	bool draw,clean;

	OptionParser parser("Test distance subclasses");
	
	parser.add("size", 'z', &size, 550, "Distance size");
	parser.add("binw", 'w', &binw, 1, "Distance bin width");

	parser.add("N", 'N', &N, 1000, "Sample size");
	parser.add("seed", 's', &seed, 74334, "PRNG seed");

	parser.add("gnuplot", 'g', &draw, false, "Draw gnuplots");
	parser.add("clean", 'c', &clean, false, "Clean up afterwards");

	vector<string> args = parser.parse(argc, argv);

	srand(seed);

	Distance distance;

	distance.resize(size, binw);


	// sanity check:

	distance.fill(0);
	distance.add(0, 1);
	if (distance.prob(0) != 1.0/binw)
		{ cerr << "(1) Error " << (1.0/binw) << " != " << (distance.prob(0)) << endl; }
	distance.add(distance.size()-1, 1);
	distance.normalize();
	if (distance.size() > binw && distance.prob(0) != 0.5/binw)
		{ cerr << "(2) Error " << (0.5/binw) << " != " << (distance.prob(0)) << endl; }
	

	for (uint i=0; i<N; i++) { 

		uint x = rand() % size;

		// Gaussian sample weight
		//double mu = size/2;
		//double sigma = size/4;
		//probability sample = 1/(sigma*sqrt(2*3.14)) * exp( -(mu-x)*(mu-x) / (sigma*sigma));

		probability sample = (double)rand() / RAND_MAX;

		distance.add(x, sample);
	}
	distance.normalize();

	cerr << "Distribution is:  " << distance << endl;

	if (draw) { gnuplot(distance, N); }

	cerr << "test dump() before smoothing." << endl;
	ofstream dout1("test-Distance.dump1.data");
	distance.dump(dout1);
	dout1.close();

	const uint K = 15;
	const double karray[K] = { 1, 2, 4, 6, 8, 10, 12, 14, 12, 10, 8, 6, 4, 2, 1 };
	vector<probability> kernel(K); std::copy(karray, karray+K, kernel.begin()); 
	distance.ksmooth(kernel);
		
	distance.normalize();
	cerr << "(Smoothed) Distribution is:  " << distance << endl;
			
	cerr << "test dump() after smoothing." << endl;
	ofstream dout2("test-Distance.dump2.data");
	distance.dump(dout2);
	dout2.close();
	if (draw) { gnuplot(distance, N); }

	for (uint i=0; i<50; i++) { 
		distance.ksmooth(kernel);
	}
	distance.normalize();

	cerr << "test dump() after smoothing many times." << endl;
	ofstream dout3("test-Distance.dump3.data");
	distance.dump(dout3);
	dout3.close();
	if (draw) { gnuplot(distance, N); }

	if (clean) { system("/bin/rm -f test-Distance.*.data"); }

	return 0;

}

	
