#ifndef IOEXAMPLE_H
#define IOEXAMPLE_H

#include "CRM.h"
#include "cvector.h"

#include <iostream>
#include <string>
using namespace std;

enum IOExampleCode { IOExSUCCESS, IOExREAD_ERROR, IOExSHORT_SEQ, IOExZERO_PROB, IOExINCOMPATABLE, IOExNUM_CODES };

/** An Example (defined in CRM.h) with read/write capabilities */
class IOExample : public Example {

  private:
  	string header;
  	string dna;
	probability w;	// weight
	string name_id;

	cvector<probability> slv;	// subsequence likelihood vector, slv[x] = P(sequence[0..x))
	
	cvector<probability> mpp;	// underlying prior probability (of a motif at
								// each location) mpp[i] = product of
								// probabilities of ALL priors[0..i), where
								// each prior is calculated as x / x+y, where x
								// is the (normalized) value for the given
								// number (e.g., conservation score), and y is
								// the normalized background (e.g. uniform).
								// pseudocounts are added to remove zeros.

  public:

	IOExample() { header=dna=""; }
	virtual ~IOExample() { }
 	
  	/** Read sequence from FASTA, calculate background using given MM */
   	IOExampleCode read(istream &in, unsigned int minimum_length, probability weight);

	/** Set subsequence probability distribution given background from a Markov Chain model */
	IOExampleCode set_background(const MM<probability> &mm);

	/** Set subsequence probability distribution given background from an arbitrary distribution */
	IOExampleCode set_background(const vector<probability> &d);

	inline void reweight(const probability &weight) { this->w = weight; }
	inline const probability& weight() const { return this->w; }
	inline const string& name() const { return this->name_id; }

	/** overriding Example virtual methods */
	const string* sequence() const { return &(dna); }
	
	probability bg(unsigned int i, unsigned int j) const { 
		return slv[j] / slv[i];
			// TODO:  This is the likelihood of [i..j), given the base pairs UPSTREAM
			//	of position `i' (which are not part of the query).  One could re-calculate
			//	the probability of the initial bases in [i..j), store all probabilites
			//	of sequence [i..i+order), or assume a uniform distribution
			//	(but I need to guarantee this is O(1)).
	}

	// DEPRECATED IOExampleCode add_prior(istream &in, probability pc);
	
	/** Assign prior probability distribution */
	template <typename _Iterator>
	void add_prior(_Iterator begin, _Iterator end);
	
	probability prior(unsigned int i, unsigned int j) const;
	
};
	
template <typename _Iterator>
void IOExample::add_prior(_Iterator begin, _Iterator end) {

	for (_Iterator i=begin; i!=end; i++) { 

		this->mpp.push_back(*i);

	}

	// 2006-09-11, decided to print this (was debugging mode only)
	if (this->mpp.size() != this->dna.length()) { 
		#if DEBUG_MODE
		cerr << "File IOExample.h, function `IOExample::add_prior(_Iterator, _Iterator)`:  ";
		#endif
		cerr << "WARNING:  Expected prior for " << this->dna.length() << " characters, "
			 << "read " << this->mpp.size() << " priors."
			 << "  (Sequence ID is \"" << this->name_id << "\")." 
			 << endl;
	}

	return;
}
	
#endif

