/*
	WSS:  read (and also store) whitespace (mostly to check for newlines)

	WSS wss;
	cin >> stuff >> wss;	
	wss.newline = number of newlines encountered in last read
	wss.ws = all the white space read in during last read
	
*/

#ifndef WSS_HEADER_H
#define WSS_HEADER_H

#include <iostream>
#include <string>
using namespace std;

struct WSS { 
	string ws;
	unsigned int newline;
	WSS() { newline=0; ws.clear(); }
	void scan(istream &in) { 
		newline = 0;
		ws.clear();
		while (in.good() && in.peek() <= ' ') {
			char c=in.get(); 
			ws.push_back(c);  
			newline += (c=='\n'?1:0); 
		}
	}
};

inline istream& operator>>(istream &in, WSS &wss) { wss.scan(in);  return in; }

#endif
