#include "custom.h"
#include "probability.h"
#include "PWM.h"


/** Prototypes for useful (?) constraining functions */

void normalize(list<pair<vector<unsigned int>, probability> >  &order);	// renormalize orderings
void palindrome(PWM<probability> &pwm);	// force palindrome
void palindrome(CRM &crm);	// all motifs

/* Force two sites (given by index numbers) to be adjacent to each other by setting 
	probabilities of orders where they are not adjacent to zero. */
void force_adjacent(unsigned int, unsigned int, const CRM&, list<pair<vector<unsigned int>, probability> >&);

/* "Center" PWM around leftmost and rightmost sites with entropy < max allowable entropy
	(and pad `pad' sites on either side) */
PWM<probability> center(const PWM<probability> &pwm, const double max_entropy, const unsigned int pad);	

void center(CRM &crm, const double max_entropy, const unsigned int pad);	// center all motifs









/**
 *
 * Alter the given CRM model.  
 *
 * Called before running the E-M (Krogh et al, 1994) algorithm 
 */
void constrain_preconditions(CRM &crm, const vector<Example*> &training_data) { 

	// crm.normalize();	// call this function if CRM is changed.

	return;	

}



/** 
 *
 * Alter the given CRM model.  
 *
 * Called after every iteration of E-M (Krogh et al, 1994).
 *
 */
void constrain_per_iteration(CRM &crm, const vector<Example*> &training_data) { 

	///// center(crm, 1.922, 1); // notox;

	// crm.normalize();	// call this function if CRM is changed.

	return;	

}



/**
 *
 * Alter the given CRM model.  
 *
 * Called after E-M, before the solution (CRM object) is returned from the
 * `train' function
 *
 */

void constrain_finalize(CRM &crm, const vector<Example*> &training_data) { 
	
	///// center(crm, 1.5001, 1); // notox;

	// crm.normalize();	// call this function if CRM is changed.

	return;	

}




/** Alter the prior probabilities over binding site order.  Typical use would
 * be to set certain orderings to zero, then renormalize.  The argument, order,
 * is a list of (full-order-most-upstream-to-most-downstream, probability)
 * pairs, where "full-order" is a vector of size == crm.size(), containing the
 * numbers 0, 1, ... , crm.size()-1 in some particular order.  "crm" is passed
 * in for reference, and cannot be changed here.
 */
void constrain_order(list<pair<vector<unsigned int>, probability> >  &order, const CRM &crm) { 

	
	
	// normalize(order);	// if you zero-out some orders, you'll have to renormalize

	return;

}








/** Normalize probabilities of each possible ordering */
void normalize(list<pair<vector<unsigned int>, probability> >  &order) {

	probability Z = 0;

	for (list<pair<vector<unsigned int>, probability> >::const_iterator i=order.begin(); i!= order.end(); i++) { 
		Z += i->second;
	}

	if (Z==0) { 
		#if CRM_DEBUG
		cerr << "WARNING (custom function):  All orderings impossible.  Resetting to uniform." << endl;
		#endif
		const unsigned int ORDERS = order.size();
		for (list<pair<vector<unsigned int>, probability> >::iterator i=order.begin(); i!= order.end(); i++) { 
			i->second = 1.0 / ORDERS;
		}
	} else {
		for (list<pair<vector<unsigned int>, probability> >::iterator i=order.begin(); i!= order.end(); i++) { 
			i->second /= Z;
		}
	}

	return;
}


/**
 * Average a PWM with it's reverse (not complement) to 
 * get a palindrome
 */
PWM<probability> palindrome_pwm(const PWM<probability> &pwm) { 

	PWM<probability> ans(pwm.width());
	ans.fill(0);
	ans.add(pwm);
	ans.add(pwm.reverse().complement());
	ans.normalize();
	return ans;

}


/** 
 * Force all motifs to be palindromic by averaging sites
 */
void palindrome(CRM &crm) { 

	for (unsigned int i=0; i<crm.size(); i++) { 
		for (unsigned int m=0; m<crm.site(i).multiplicity(); m++) { 
			PWM<probability> pal = palindrome_pwm(crm.site(i).motif(m));
			crm.site(i).motif(m).fill(0);
			crm.site(i).motif(m).add(pal);	// replace with `pal'
		}
	}

	return;
}


/**
 * Force index1 and index2 to be adjacent to one another 
 *	by setting to zero the probability of orderings that do not have that property.
 *	NOTE:  normalize required after this call 
 */
void force_adjacent(unsigned int index1, unsigned int index2, const CRM &crm, list<pair<vector<unsigned int>, probability> >  &order) {

	for (list<pair<vector<unsigned int>, probability> >::iterator i = order.begin(); i!=order.end(); i++) { 
		
		bool adjacent = false;
		
		for (vector<unsigned int>::const_iterator up = i->first.begin(); ; up++) { 	// up <=> upstream site

			vector<unsigned int>::const_iterator down = up;
			down++;		// down <=> downstream site (just after *up in this ordering)
			if (down==i->first.end()) { break; }
				// NOTE:  this loop will never execute for ordering sizes of 1.

			if (*up == index1 && *down == index2 || *up == index2 && *down == index1 ) {

				adjacent = true;
				break;
			}
		}

		if (!adjacent) { i->second = 0; }
	}

}


PWM<probability> center(const PWM<probability> &pwm, const double max_entropy, const unsigned int pad) {

	unsigned int L = 0;
	for (; L < pwm.width() && pwm.entropy(L) > max_entropy; L++);
		// if entropy(L) > max_allowable_entropy, keep looking...

	unsigned int R = pwm.width()-1; 
	for (; R > L && pwm.entropy(R-1) > max_entropy; R--);

	int start = (int)L - (int)pad;
	unsigned int end = R + pad + 1;

	#if CRM_DEBUG
	assert(end - start > 0);
	#endif

	PWM<probability> ans(end - start);
	unsigned int ans_index = 0;
	for (int site=start; site<(int)end; site++) { 
		for (unsigned int base=0; base<DNA_ABLEN; base++) { 
			if (0 <= site && site < (int)pwm.width()) { 
				ans(ans_index, base) = pwm(site,base);
			} else {
				ans(ans_index, base) = 1.0 / DNA_ABLEN;
			}
		}
		ans_index++;
	}
	return ans;	
}

void center(CRM &crm, const double max_entropy, const unsigned int pad) { 
	
	for (unsigned int site=0; site<crm.size(); site++) { 
		for (unsigned int m=0; m<crm.site(site).multiplicity(); m++) { 
			crm.site(site).motif(m) = center(crm.site(site).motif(m), max_entropy, pad);
		}
	}

	return;
}
