

#include "grid.h"
#include <string>
#include <list>
#include <vector>
#include <iomanip>
#include <sstream>

using namespace std;


string pad(const string &s, int L) { 

	string ans = s;
	for (int i=s.length(); i<L; i++) { 
		ans = " " + ans;
	}
	return ans;
}

string repeat(const string &s, int r) { 
	
	string ans = "";
	for (int i=0; i<r; i++) { 
		ans = ans + s;
	}
	return ans;
}

void print_classification_grid(int TP, int FP, int TN, int FN, ostream &out)  {
	print_classification_grid((double) TP, (double) FP, (double) TN, (double) FN, out);
}
void print_classification_grid(double TP, double FP, double TN, double FN, ostream &out) { 

	list<string> SL;
	SL.push_back(itos(TP));
	SL.push_back(itos(FP));
	SL.push_back(itos(TN));
	SL.push_back(itos(FN));
	SL.push_back(itos(TP+FN));	// first column total
	SL.push_back(itos(FP+TN));	// second

	int L = longest(SL.begin(), SL.end());

	string TPs = pad(itos(TP), L);
	string FPs = pad(itos(FP), L);
	string TNs = pad(itos(TN), L);
	string FNs = pad(itos(FN), L);

	string RT1 = pad(itos(TP+FP), L);	// first row total
	string RT2 = pad(itos(FN+TN), L);	
	string CT1 = pad(itos(TP+FN), L);	// first column total
	string CT2 = pad(itos(FP+TN), L);	
	string TTT = pad(itos(TP+FP+FN+TN), L);	// all 

	out << "        Actual     " << endl;
	//out << "       + " << repeat(" ", L) << " - " << repeat(" ", L) << endl;
	out << "      " << repeat(" ", L-1) << "+" << "   " << repeat(" ", L-1) << "-" << endl;
	out << "P    -" << repeat("-", L) << "- -" << repeat("-", L) << "-" << endl;
	out << "r + | " << TPs << " | " << FPs << " | " << RT1 << endl;
	out << "e   |-" << repeat("-", L) << "-+-" << repeat("-", L) << "-|" << endl;
	out << "d - | " << FNs << " | " << TNs << " | " << RT2 << endl;
	out << "     -" << repeat("-", L) << "- -" << repeat("-", L) << "-" << endl;
	out << "      " << CT1 << "   " << CT2 << "   " << TTT << endl;

	return;
}



void print_grid(const vector<vector<string> > &m, ostream &out, 
                const string &delim, const string &rowsep, int justify) { 

	// delim = column separator (e.g. vertical line)
	// rowsep = row separator (e.g. horizontal line or nothing)

	const int ROWS = m.size();
	const int COLS = m.size() ? m[0].size() : 0;

	vector<int> col_width(COLS);
	for (int row=0; row<ROWS; row++) { 
	for (int col=0; col<COLS; col++) { 
		int cell_width = m[row][col].length();
		if (cell_width > col_width[col]) { 
			col_width[col] = cell_width;
		}
	}}

	for (int row=0; row<ROWS; row++) { 

		// print row separator
		if (rowsep != "") { 
			for (int col=0; col<COLS; col++) { 
				out << repeat(rowsep, col_width[col]/rowsep.length()) << rowsep.substr(0,col_width[col]%rowsep.length());
				out << repeat(" ", delim.length());
			}
			out << repeat(" ", delim.length());
			out << endl;
		}

		for (int col=0; col<COLS; col++) {
		
			int w = m[row][col].length();
			int p = col_width[col] - w;
			
				   if (justify <  0) { out << m[row][col] << repeat(" ", p);	// left justify
			} else if (justify == 0) { out << repeat(" ", (p/2)) << m[row][col] << repeat(" ", p-(p/2));	// center
			} else if (justify >  0) { out << repeat(" ", p) << m[row][col]; }
			
			out << delim;

		}

		out << endl;
	}

	// print row separator
	if (rowsep != "") { 
		out << repeat(" ", delim.length());	// row separator before row.
		for (int col=0; col<COLS; col++) { 
			out << repeat(rowsep, col_width[col]/rowsep.length()) << rowsep.substr(0,col_width[col]%rowsep.length());
			out << repeat(" ", delim.length());
		}
		out << repeat(" ", delim.length());	
		out << endl;
	}

	return;
}


