#ifndef PROBABILITY_TYPE_DEFINITION_H
#define PROBABILITY_TYPE_DEFINITION_H

#include "logscale.h"

/**
 *
 * Define the underlying type of the probability representation used throughout this project.
 *	NOTE:  You must adjust the function below.
 *
 */
//typedef long double probability;
typedef logscale probability;


/**
 *
 * Since probability may or may not be represented as a log scale, we need
 * special consideration for reading/assigning values already in log scale:  if
 * they are too small to be converted to linear, we'll lose information.
 * Therefore, when reading log-scale values (say, from a file containing only
 * log-scale values), you should call this function.
 */
inline probability interpret_logscale_probability(long double logscale_value) {

	//return ((probability)exp(logscale_value));	// if linear scale
	return logscale::loginit(logscale_value); 
}

#endif
