/**
 *
 *	Compute reverse complement of input sequence.
 *	
 *
 */

#include <stdlib.h>

#include <vector>
#include <iostream>
#include <fstream>
#include <sstream>
#include <string>
#include <iterator>
using namespace std;


#include "genomic.h"
#include "fasta.h"
#include "Option.h"

/** input FASTA record and output reverse complement version */
void fasta_revcomp(istream &in, ostream &out, bool reverse=true) { 
	
	pair<string, string> data;
	fasta_read(in, data.first, data.second);
	out << data.first << endl << revcomp(data.second, reverse) << endl;
	return;

}


void fasta_revcomp_file(istream &in, ostream &out, bool reverse=true) { 
	
	while (in.good()) { 
		fasta_revcomp(in, out, reverse);
	}
}
	
	

int main(int argc, char **argv) { 

	bool reverse;
	bool command;

	OptionParser parser("Reverse and complement DNA/IUPAC sequences");
	
	parser.add("norev", 'r', &reverse, true, "Do not reverse the sequence, only complement");
	parser.add("command", 'c', &command, false, "Read sequence data from command line argument(s) (Not FASTA)");
	parser.add("cmd", 'a', &command, false, "Same as [--command|-c] above");

	vector<string> args = parser.parse(argc, argv, " < FASTA file(s)");

	if (command) {
		// read from command line
		for (unsigned int s=0; s<args.size(); s++) { 
			cout << "> sequence #" << (s+1) << endl
				 << revcomp(args[s], reverse) << endl;
		}
	} else if (args.size()) { 
		// there are filenames on the command line
		for (vector<string>::iterator i=args.begin(); i!=args.end(); i++) { 
			ifstream fin(i->c_str());
			if (!fin) { cerr << *i << "?"; }
			else { fasta_revcomp_file(fin, cout, reverse); }
		}
	} else {
		// read from stdin
		fasta_revcomp_file(cin, cout, reverse);
	}
			
	return 0;
}
	
