
#include <vector>
#include <iostream>
#include <fstream>
#include <math.h>
using namespace std;

#include "markov.h"
#include "Option.h"
#include "logscale.h"



int main(int argc, char **argv) { 

	double pc;

	OptionParser parser("Test markov.h.  Read and echo a Markov data file");
	parser.add("pc", 'p', &pc, 0.0, "Pseudocount to add");
	vector<string> args = parser.parse(argc, argv, " < Markov file > copy of data + pseudocount");

	istream *in;
	ifstream fin;
	if (args.size()) { 
		fin.open(args[0].c_str());
		if (!fin) { cerr << args[0] << "?" << endl; exit(-1); }
		in = &fin;
	} else {
		in = &cin;
	}

	MM<logscale> mm;
	mm.read(*in);
	cerr << "read Markov model order " << mm.order() << endl;

	if (args.size()) { fin.close(); }

	string S[6] = { "acgtAtcgtC",
	               "AAAAAaaaaa",
				   "GG",
					"A",
					"",
				"acgtAtcgtCacgtAtcgtC" };
	
	for (int s=0; s<6; s++) { 
		cerr << "Probability of '" << S[s] << "' = " << mm.likelihood(S[s]) << endl;
	}


	string sequence = S[0];
	cerr << "Calculate subsequence probabilities of '" << sequence << "'..." << endl;
	vector<logscale> sub = mm.subsequence_likelihood(sequence);
	
	cerr << "slm_00 = " << "P('" << sequence.substr(0,0) << "') = " << (sub[0] / sub[0]) << endl; 
	cerr << "slm_01 = " << "P('" << sequence.substr(0,1) << "') = " << (sub[1] / sub[0]) << endl;
	cerr << "slm_25 = " << "P('" << sequence.substr(2,3) << "') = " << (sub[5] / sub[2]) << endl;
	cerr << "all    = " << "P('" << sequence.substr(0,sequence.length()) << "') = " << sub[sequence.length()] << endl;

	unsigned int TO = mm.order() / 2;
	cerr << "entries in order " << TO << ":  ";
	unsigned int TO_count = 0;
	for (const logscale *i = mm.begin(TO); i!=mm.end(TO); i++)  { TO_count++; }
	cerr << mm.begin(TO)[0] << ", " << mm.begin(TO)[1] << " ... (total of " << TO_count << ") ... " << *(mm.end(TO)-1) << endl;
	
	cerr << "Add pseudocount..." << endl;
	mm.pseudocount(pc);
	mm.normalize();

	cerr << "Write data..." << endl;
	mm.write(cout);
	cerr << "Have a nice day." << endl;

	return 0;

}

