/*



*/

#include <string>
#include <list>
#include <sstream>
#include <vector>
#include <map>
#include <iostream>
#include <fstream>
using namespace std;

#include "OptionParser.h"
#include "datafile.h"

struct SortRolesByPriority {
	bool operator()(const Role *LHS, const Role *RHS) { 
		return (LHS->priority < RHS->priority);
	}
};

/**
 * read datafiles and create a datafile that combines conditions values and gene expression value.
 *	this does a thorough job of error checking, just to make sure everything's okay
 */
void filter_roles(ostream &out, string roles_filename, string expression_filename) {

	list<Role> roles = read_roles(roles_filename, cerr);
	
	vector<string> expression_header;
	vector<pair<string, vector<double> > > expression;
	read_expression(expression_filename, expression_header, expression, cerr);

	map<string,bool> gmap;
	for (vector<string>::const_iterator i=expression_header.begin(); i!=expression_header.end(); i++) { 
		gmap[*i] = true;
	}

	for (list<Role>::iterator r=roles.begin(); r!=roles.end();) { 
		if (gmap.find(r->regulator) == gmap.end() || gmap.find(r->regulatee) == gmap.end()) { 
			r = roles.erase(r);
		} else {
			r++;
		}
	}

	// copy to vector, sort by priority
	vector<const Role*> rv;
	rv.reserve(500);
	for (list<Role>::const_iterator r=roles.begin(); r!=roles.end(); r++) { rv.push_back(&(*r)); }
	std::sort(rv.begin(), rv.end(), SortRolesByPriority());

	for (int i=0; i<rv.size(); i++) { 
		if (rv[i]) { 
			for (int j=i+1; j<rv.size(); j++) { 
				if (rv[j]) { 
					if (   rv[i]->regulator == rv[j]->regulator
					    && rv[i]->regulatee == rv[j]->regulatee) { 

						rv[j] = NULL;
					}
				}
			}
		}
	}

	// write roles
	for (vector<const Role*>::const_iterator r=rv.begin(); r!=rv.end(); r++) {
		if (*r) { 
			out << (*r)->regulator << '\t' << (*r)->regulatee << '\t'
				<< (*r)->role << '\t' << (*r)->priority << endl;
		}
	}

	return;
	
}


int main(int argc, char **argv) {

	string roles_filename, expression_filename;
	string output_filename;
	
	bool verbose;

	OptionParser parser("Filter roles to include only those mentioned in an expression file");

	parser.add(Option("roles", 'r', &roles_filename, "",
		"Roles file:  records are regulator-name regulatee-name Activator|Repressor priority", true));
	parser.add(Option("expression", 'x', &expression_filename, "",
		"Expression filename:  header row is gene names, records are array-name expression for each \
			gene in header row", true));
	parser.add(Option("output", 'o', &output_filename, "", "output file"));

	vector<string> args = parser.parse(argc, argv, "[output filename]");

	// assign output filename if not given as option
	if (output_filename == "" && args.size()) { output_filename = args[0]; }

	if (output_filename == "") { 
		filter_roles(cout, roles_filename, expression_filename);
	} else {
		ofstream fout(output_filename.c_str());
		filter_roles(fout, roles_filename, expression_filename);
		fout.close();
	}

	return 0;

}

