/*
	General concepts used in this package

	All Variables have a unique ID.  Classes in this
	package refer to variables via it's unique ID.

*/

#ifndef PROBABILITY_H
#define PROBABILITY_H 1

#include <string>
#include <vector>
using namespace std;


typedef vector<double> distribution;


/** A random variable */
struct Variable { 
	string name;	// it's name
	int ID;			// it's unique integer ID
	vector<string> values;	// it's possible values

	Variable::Variable(string n, int id, int v) : name(n), ID(id) { 
		for (int i=0; i<v; i++) { 
			ostringstream oss;
			oss << i;
			values.push_back(oss.str());
		}
	}

	template <typename _Iterator>
	Variable(string n, int id, _Iterator value_names_begin, _Iterator end);

	inline int arity() const { return values.size(); }
};

template <typename _Iterator>
Variable::Variable(string n, int id, _Iterator value_names_begin, _Iterator end)
	: name(n), ID(id) {
	for (_Iterator i=value_names_begin; i!=end; i++) { 
		values.push_back(*i);
	}
}

/** A good print function for variables that you can copy?
ostream& operator<<(ostream &out, const Variable &variable) { 
	out << "Variable:  "
		<< "name=" << variable.name << ", "
	    << "ID=" << variable.ID << ", " 
		<< variable.arity() << " values:  { ";
	for (vector<string>::const_iterator v=variable.values.begin(); 
	                                    v!=variable.values.end(); v++) { 
		out << (*v) << " ";
	}
	out << "}";
	return out;
}
*/
	


#endif
