/**
 * Test TTest
 *
 */


#include "gaussian.h"
#include "OptionParser.h"
#include "TTest.h"

#include <stdlib.h>

#include <iostream>
#include <fstream>
#include <vector>

using namespace std;

int main(int argc, char **argv) { 

	int N;
	double stdev;
	double mean;
	int seed;
	double con;

	OptionParser parser("test TTest.h");
	parser.add(Option("points", 'n', &N, 100, "number of data points"));
	parser.add(Option("mean", 'u', &mean, 1.0, "mean of second Gaussian (compare to 0.0)"));
	parser.add(Option("stdev", 'd', &stdev, 1.0, "standard deviation both Gaussians"));
	parser.add(Option("seed", 's', &seed, 6141976, "PRNG seed"));
	parser.add(Option("con", 'c', &con, 0.05, "confidence threshold"));

	parser.parse(argc, argv, "(remaining arguments ignored)");
	
	srand(seed);

	Gaussian g1(0.0, stdev);
	Gaussian g2(mean, stdev);

	vector<double> points1, points2;

	for (int i=0; i<N; i++) { 
		points1.push_back( g1.generate() );
		points2.push_back( g2.generate() );
	}

	double tvalue;
	bool sdif = TTest::twotailed(points1.begin(), points1.end(), points2.begin(), con, tvalue);

	cout << "tvalue is " << tvalue << ".  " << (sdif?"REJECT":"Accept") << " null hypothesis." << endl;

	return 0;

}

