#!/usr/bin/python

# transpose a file 
#	python transpose.py

import sys;

# transpose a matrix read from input
#
#	EOR_DELIM:  how should I separate output's records?
#	EOL_DELIM:  how should I separate output's rows?
#
def transpose(instream=sys.stdin, outstream=sys.stdout, EOR_DELIM='\t', EOL_DELIM='\n'):

	matrix = [ ];

	line = instream.readline();
	while (line != ''):
		if (line[len(line)-1] == '\n'): line = line[0:len(line)-1];
		matrix = matrix + [ line.split() ];	# matrix as list of lines (no newlines)
		line = instream.readline();

	if (len(matrix) > 1 and len(matrix[1]) - len(matrix[0]) == 1):
		# first row is short (assume because of header row,column)
		matrix[0] = [''] + matrix[0];	# prefix white space

	for i in range(0,len(matrix[0])):
		for j in range(0,len(matrix)):
			outstream.write(str(matrix[j][i]));
			if (j+1 < len(matrix)): outstream.write(EOR_DELIM);
		outstream.write(EOL_DELIM);


# main:

instream = sys.stdin;
if (len(sys.argv) > 1):	instream = open(sys.argv[1]);	# use file if given

transpose(instream);

if (instream != sys.stdin): instream.close();


