#!/usr/bin/env python

import numpy as np
import matplotlib.pyplot as plt

"""
READ
btrfs|4.25456666666667|26.4910133333333|3.39209333333333|20.46044921875
ext2|5.946|21.2416166666667|4.99621666666667|15.3362121582031
ext4|4.70813333333333|31.65105|3.88711|21.279736328125
reiserfs|6.39896666666667|41.7988633333333|5.16488666666667|20.3310302734375
xfs|7.42466666666667|35.1762625|6.53575833333333|20.4955596923828

WRITE
btrfs|10.2434666666667|73.1256333333333|8.54223666666667|19.4814697265625
ext2|12.0781|51.84863|10.4902433333333|17.4150146484375
ext4|9.73023333333333|71.52496|8.36874333333333|19.2935302734375
reiserfs|9.9348|70.68903|8.52073333333333|19.2480224609375
xfs|9.99686666666667|72.4159866666667|8.46090333333333|19.248876953125
"""

data = {
        'ext2' : {
            'write' : 12.0781,
            'read' : 5.946,
            },
        'ext4' : {
            'write' : 9.73023333333333,
            'read' : 4.70813333333333,
            },
        'reiserfs' : {
            'write' : 9.9348,
            'read' : 6.39896666666667,
            },
        'xfs' : {
            'write' : 9.99686666666667,
            'read' : 7.42466666666667,
            },
        'btrfs' : {
            'write' : 10.2434666666667,
            'read' : 4.25456666666667,
            },
}

N = len(data.keys())
readMeans = []
writeMeans = []
keys = []
for fs, datum in data.iteritems():
    keys.append(fs)
    readMeans.append(datum['read'])
    writeMeans.append(datum['write'])

width = 0.35       # the width of the bars
ind = np.arange(N) + width / 2  # the x locations for the groups

plt.rcParams.update({'font.size':6})
fig = plt.figure(figsize=(3,2))
ax = fig.add_subplot(111)
rects1 = ax.bar(ind, readMeans, width, color='r') #, yerr=menStd)
rects2 = ax.bar(ind+width, writeMeans, width, color='y') #, yerr=womenStd)

# add some
ax.set_ylabel('Average time (minutes)')
#ax.set_title('Elapsed time of TestDFSIO (nrFiles = 100, fileSize = 100)')
ax.set_xticks(ind+width)
ax.set_xticklabels( keys )

ax.legend( (rects1[0], rects2[0]), ('read', 'write'), loc='upper left' )

def autolabel(rects):
    # attach some text labels
    for rect in rects:
        height = rect.get_height()
        ax.text(rect.get_x()+rect.get_width()/2., 1.05*height, '%.02g' % height,
                ha='center', va='bottom')

#autolabel(rects1)
#autolabel(rects2)

#plt.show()
plt.savefig('runtimes.eps')
