#!/usr/bin/env python

"""
This script computes and plots CDFs of seek distances using matplotlib
"""
import glob
import os
import pickle

from sys import stderr
import sys
import sh
from blktrace import Trace

filesystems = [
        #'ext4',
        #'ext2',
        #'xfs',
        'reiserfs',
        #'btrfs',
]

run_types = [
        'read',
        'write',
]

hosts = [
        'abaddon',
        'lilith',
        'baal',
]

"""
def compile_traces(session, num_trials):
    for fs in filesystems:
        for host in hosts:
            for trial in range(10):
                filename = 'blktrace/%s/%s.%s.%d' % (fs, host, fs, trial)
                seq_number = 0
                print >>stderr, 'parsing ' + filename
                for line in sh.grep(sh.blkparse(filename, f = "%a %S %s\\n", _piped=True), '^Q', _ok_code=[0,1], _iter = True):
                    sector_num = line.split()[1]
                    session.add(Trace(fs, seq_number, host, trial, sector_num))
                    seq_number += 1
                session.commit()
"""

def get_traces(fs, host, trial, run_type):
    filename_glob = os.path.join('blktrace', fs, '%s.%s.%s.%d.blktrace.*' % (host, fs, run_type, trial))
    traces = []
    for filename in glob.glob(filename_glob):
        with open(filename, 'rb') as f:
            while True:
                bytes_read = f.read(Trace.trace_size)
                if not bytes_read or len(bytes_read) == 1: break
#                try:
                trace = Trace(bytes_read)
#                except:
#                    return sorted(traces)
                if trace.pdu_len > 0:
                    trace.extra_data = f.read(trace.pdu_len)

                traces.append(trace)
                if trace.verified:
                    continue
#                print 'not verified'
    return sorted(traces)

def main():
    for run_type in ('read', 'write'):
        for fs in filesystems:
            for host in hosts:
                for trial in [6,7]:
                    seek_distances = []
                    print >>stderr, 'parsing %s/%s/%s/%d' % (fs, host, run_type, trial)
                    filename = 'blktrace/%s/%s.%s.%s.%d' % (fs, host, fs, run_type, trial)
                    last_block_number = last_size = None
                    for line in sh.grep(sh.blkparse([filename, '-f', r'%a %S %n\n']), r'^D', _iter = True):
                        _, block_number, size = line.split()
                        block_number = int(block_number)
                        size = int(size)
                        if last_block_number != None:
                            seek_distances.append(abs(block_number - (last_block_number + last_size)))
                        last_block_number, last_size = block_number, size
                    output_filename = 'seek_distances/%s.%s.%s.%d' % (fs, host, run_type, trial)
                    with open(output_filename, 'w') as f:
                        pickle.dump(seek_distances, f)


if __name__ == '__main__':
    main()
