// NCacheEntry.java

import java.io.*;
import java.util.Date;

/** 
 *  A cached object.
 */
public class NCacheEntry implements Serializable
{
    /** @serial The key for the object usually a URL or a filename.*/
    private Object key = null;
    /** @serial The date this entry was cached. */
    private Date cachetime = null;
    /** @serial The date this entry expires.*/
    private Date expires = null;
    /** @serial The file the object is cached to.*/
    private String filename = null;
    /** @serial The number of bytes this object is.*/
    private long size = 0;
    /** @serial The number of bytes the content is */
    private long contentLength = -1;
    /** @serial The unique id of the object.*/
    private long id = 0;
    /** @serial The hooked data of the cached object. */
     private Object datahook;

    /** Create a new CacheEntry for given key and filename
     * @param key the key for the object.
     * @param filename the filename were we store our data
     */
    public NCacheEntry (Object key, String filename, long id) {
	this.key = key;
	this.filename = filename;
	this.id = id;
    }    
    
    /** Get the filename were data is stored
     * @return a filename
     */
    public String getFileName () {
	return filename;
    }
    
    /** set the filename were we will save data
     * @param filename the name of the File were data is saved.
     */
    protected void setFileName (String filename) {
	this.filename = filename;
    }
    
    /** Set the key were holding data for
     * @param key the key we have data for
     */
    protected void setKey (Object key) {
	this.key = key;
    }
    
    /** Get the key were holding data for
     * @return the keyobject
     */
    public Object getKey () {
	return key;
    }   
    
    /** Get the size of our file
     * @return the size of our data
     */
    public long getSize () {
	return size;
    }  
    /** Sets the size of our data
     * @param size the new Size
     */
    public void setSize (long size) {
	this.size = size;
    }

    /** Get the contentLength of our file
     * @return the contentLength of our data
     */
    public long getContentLength () {
	return contentLength;
    }  
    /** Sets the contentLength of our data
     * @param contentLength the new ContentLength
     */
    public void setContentLength (long contentLength) {
	this.contentLength = contentLength;
    }

    /** Get the expiry-date of our file
     * @return the expiry date of our data
     */
    public Date getExpires () {
	return expires;
    }  
    /** Sets the expirydate of our data
     * @param d the new expiry-date.
     */
    public void setExpires (Date d) {
	this.expires = d;
    }
    
    /** Get the id of our entry.
     * @return the id of the entry.
     */
    public long getId () {
	return id;
    }

    /** Get the hooked data.
     * @return the the hooked data.
     */
      public Object getDataHook () {
  	return datahook;
      }  
    /** Sets the data hook for this cache object.
     *  Since it is not always possible to make the key hold this...
     * @param o the new data.
     */
      public void setDataHook (Object o) {
  	this.datahook = o;
      }
}




