#include "doWl.h"
#include "specWl.h"

#define MAX(a,b) ( ( (a) > (b) ) ? (a) : (b)  )
#define MIN(a,b) ( ( (a) < (b) ) ? (a) : (b)  )
#define copystring(x,y) { x = (char *) malloc((unsigned int) strlen(y)+1); strcpy(x,y);}

typedef struct {
    WLPARAM param;  /* parameters achieved */
    WLPARAM target; /* parameters fed to specWl to shoot for */
    WLPERF perf;    /* performance achieved */
} WLRESULT;

#define MAXRESULTNUM 5000 /* maximum number of results we can get */
#define MAXSIMPLERESULTNUM 1000 /* maximum number of points in a simple result
				    graph */

typedef struct {
    double sortIndex;
    double performance;
    int runNumber;
} QSORTELEMENT;

typedef struct {
    double paramValue;
    double performance;
    char *comment;
} WLSIMPLERESULT;

/* postive parameter means (see bench/wl.notes)
    1) generally positive slopes when plotted against performance
    2) programs would prefer to have small values of these parameters
   
   negative parameter means
    1) generally negative slopes when plotted against performance
    2) programs would prefer to have large values of these parameters
*/


/* #define LOGPARAM (UNIQUEBYTES | REUSE | SIZEMEAN | PROCESSNUM | CPUTHINK | ALIGNQUANTA) */
#define LOGPARAM (REUSE | SIZEMEAN | PROCESSNUM | CPUTHINK | ALIGNQUANTA)

/* ???
#define EXPLORING_PARAM (UNIQUEBYTES | REUSE | HITDEPTH | READPROB | SIZEMEAN | PROCESSNUM | SEQPROB)
*/
/* ??? not exploring hitDepth
#define EXPLORING_PARAM (UNIQUEBYTES | REUSE | READPROB | SIZEMEAN | PROCESSNUM | SEQPROB)
*/
/* ??? not exploring reUse */
#define EXPLORING_PARAM (UNIQUEBYTES | READPROB | SIZEMEAN | PROCESSNUM | SEQPROB)

#ifdef SPRITE
#define CONFBOUND .9 /* confidence bound */
#define CONFINTERVAL .10
	    /* size of confidence bound should be < 5% of the value */
#else /* SPRITE */
#define CONFBOUND .9 /* confidence bound */
#define CONFINTERVAL .10
	    /* size of confidence bound should be < 10% of the value */
#endif /* SPRITE */

#define MINREUSE 2 /* minimum value of reUse to start at */
#define MAXREUSE 10 /* maximum value of reUse to have before using multiple
			iterations of doWl to achieve longer runs */

#ifdef SUN_OS
#define SKIPSECONDS 1200 /* on SunOS, the first run or two are often slower than
		    the other runs (don't know why) */
#else
#define SKIPSECONDS 600
#endif /* SUN_OS */
