#include <stdio.h>
#include <math.h>
#include "adaptWl.h"
#include "stat.h"
#include <string.h>
/* #include <strings.h> */

#define MAXRUNLISTSTR 10000 /* max length of the string which holds all runs
				in a group */

int condense(whichParam, specPtr, minSpecPtr, maxSpecPtr, result, resultNum,
	simpleResult)
    int whichParam;
    WLPARAM *specPtr;
    WLPARAM *minSpecPtr, *maxSpecPtr;
    WLRESULT result[MAXRESULTNUM];
    int resultNum;
    WLSIMPLERESULT simpleResult[MAXSIMPLERESULTNUM];
{
    /* condense and sort all points that match specPtr (whichParam doesn't
	have to match)

	returns the number of points in the match (after they've been combined
	    to form confidence intervals)
    */

    int i;
    int qsortNum;
    QSORTELEMENT qsortArray[MAXSIMPLERESULTNUM];
    AutoStat sortParamStat;
    AutoStat perfStat;
    int startRun;
    char runString[10]; /* string version of a run number */
    char runListStr[MAXRUNLISTSTR]; /* concatenation of all runs */
    char tmpString[MAXRUNLISTSTR];
    int simpleResultNum;

    int qsortCompare();
    double convertParamVal();
    char *convertParamStr();
    void qsort();
    unsigned int paramDiff();
    int inRange();
    void *malloc();

    qsortNum = 0;
    simpleResultNum = 0;

    for (i=0; i<resultNum; i++) {
	/* compare the target instead of the actual workload parameters.  This
	    prevents using lots of extra workload results.  The target is
	    guaranteed to be close to the actual workload anyway, since
	    I check it in the run() routine */
	/* note that we need to make sure throughput >= 0, since that's how
	    I flag the run as not matching the target parameters) */
	if (paramDiff(specPtr, &(result[i].target), whichParam, 0, 10.0) == 0 &&
	    inRange(&(result[i].target), minSpecPtr, maxSpecPtr) &&
	    result[i].perf.throughput>=0) {
	    /* matched */

	    /* put into array for sorting */
	    qsortArray[qsortNum].sortIndex =
		convertParamVal( &(result[i].param), whichParam);
	    qsortArray[qsortNum].performance = result[i].perf.throughput;
	    qsortArray[qsortNum].runNumber = i;
	    qsortNum++;
	    if (qsortNum >= MAXSIMPLERESULTNUM) {
		printf("error: qsortNum too large (%d)\n", qsortNum);
		exit(1);
	    }
	}
    }
    qsort( (char *)qsortArray, qsortNum, sizeof(QSORTELEMENT), qsortCompare);

    /* now the runs are sorted according to the parameter being plotted */

    /* group the runs according to the parameter being plotted */

    runListStr[0] = '\0';
    startRun = qsortArray[0].runNumber;
    InitAutoStat(&sortParamStat, 1, 1);
    InitAutoStat(&perfStat, 1, 1);
    for (i=0; qsortNum>0 && i<=qsortNum; i++) {
	/*
	if (i<qsortNum) {
	    printf("%d: %lf %lf ; run %d\n", i, qsortArray[i].sortIndex,
		qsortArray[i].performance, qsortArray[i].runNumber);
	}
	*/
	/* the last time through this loop is simply to process the
	    final group */

	/* note that the criteria for closeness is a little closer than
	    normal (2 instead of 1) */
	if (i==qsortNum ||
	    (whichParam & paramDiff(&(result[startRun].param),
		&(result[qsortArray[i].runNumber].param), NOPARAMETER, 0, 2.0))
	    != 0
	   )
	{
	    /* finished a group */
	    /*
	    printf("%lf %lf ; %lf%% conf bound on perf = %lf, runs %s\n",
		AveStat(&sortParamStat), AveStat(&perfStat), CONFBOUND*100,
		ConfStat(&perfStat, CONFBOUND),
		runListStr);
	    */
	    simpleResult[simpleResultNum].paramValue =
		AveStat(&sortParamStat);
	    simpleResult[simpleResultNum].performance =
		AveStat(&perfStat);
	    sprintf(tmpString,
		"%lf%% conf bound on perf = %lf, runs %s", CONFBOUND*100,
		ConfStat(&perfStat, CONFBOUND), runListStr);
	    copystring(simpleResult[simpleResultNum].comment, tmpString);
	    simpleResultNum++;
	    if (simpleResultNum >= MAXSIMPLERESULTNUM) {
		printf("error: simpleResultNum too large (%d)\n",
		    simpleResultNum);
		exit(1);
	    }
	    runListStr[0] = '\0';
	    InitAutoStat(&sortParamStat, 1, 1);
	    InitAutoStat(&perfStat, 1, 1);
	    startRun = qsortArray[i].runNumber;
	}
	if (i<qsortNum) {
	    AddAutoStat(&sortParamStat, qsortArray[i].sortIndex);
	    AddAutoStat(&perfStat, qsortArray[i].performance);
	    sprintf(runString, "%d ", qsortArray[i].runNumber);
	    if (strlen(runString) + strlen(runListStr) >= MAXRUNLISTSTR) {
		printf("runListStr got too long.  So far it's: %s\n",
		    runListStr);
		exit(1);
	    }
	    strcat(runListStr, runString);
	}
    }

    return(simpleResultNum);
}

int qsortCompare(qsortElPtr1, qsortElPtr2)
    QSORTELEMENT *qsortElPtr1, *qsortElPtr2;
{
    if (qsortElPtr1->sortIndex == qsortElPtr2->sortIndex) {
	return(0);
    } else if (qsortElPtr1->sortIndex < qsortElPtr2->sortIndex) {
	return(-1);
    } else {
	return(1);
    }
}

double interpolate(x1,y1, x2, y2, y, interpolateOnly)
    double x1, y1, x2, y2, y;
    int interpolateOnly;
{
    /* return the x value that corresponds to the y (should be in between
	points 1 and 2) */
    double result;
    
    if (y1 == y2) {
	result = x1;
    } else {
	if ( interpolateOnly && (y<MIN(y1,y2) || y>MAX(y1,y2) ) ) {
	    printf("warning: interpolate called to extrapolate\n");
	    printf("point 1:(%lf, %lf); point 2:(%lf, %lf)\n", x1,y1, x2,y2);
	    printf("y = %lf\n", y);
	    exit(1);
	}
	result = x1 - (y1-y)*(x1-x2)/(y1-y2);
    }
    return(result);
}
