/* format of input parameters:
    -x start
    -x min-
    -x -max
    -x min-max
    -x min-start-
    -x -start-max
    -x min-start-max
*/

#include <stdio.h>
#include <sys/types.h>
#include <string.h>
/* #include <strings.h> */
#include "option.h"
#include <sys/time.h>
#include "specWl.h"
#include <math.h>

#define copystring(x,y) { x = (char *) malloc((unsigned int) strlen(y)+1); strcpy(x,y);}
#define SEP '-'
#define STRLENGTH 100

void getParamAdaptWl(argc, argv, minSpecPtr, maxSpecPtr, specPtr, maxRunTimePtr,
	fileServerPtr, readResultFile, noNarrowPtr, refineIterPtr,
	randomExploreNumPtr, orthogonalExploreNumPtr, kneeExploreNumPtr,
	compareFilePtr, useAllResultsFlagPtr, minRunTimePtr, warmStartFlagPtr,
	findPlateauPtr, flushPossiblePtr, focalUnique, numExplorePtr)
    int argc;
    char **argv;
    WLPARAM *minSpecPtr;
    WLPARAM *maxSpecPtr;
    WLPARAM *specPtr;
    int *maxRunTimePtr;
    char **fileServerPtr;
    char **readResultFile;
    int *noNarrowPtr;
    int *refineIterPtr;
    int *randomExploreNumPtr;
    int *orthogonalExploreNumPtr;
    int *kneeExploreNumPtr;
    char **compareFilePtr;
    int *useAllResultsFlagPtr;
    int *minRunTimePtr;
    int *warmStartFlagPtr;
    int *findPlateauPtr;
    int *flushPossiblePtr;
    char **focalUnique;
    int *numExplorePtr;
{
    /*
    double minUniqueBytesKB, maxUniqueBytesKB, uniqueBytesKB;
    double minSizeMeanKB, maxSizeMeanKB, sizeMeanKB;
    double minAlignQuantaKB, maxAlignQuantaKB, alignQuantaKB;
    */

    Option optionArray[32];
    char *uniqueBytesStr;
    char *reUseStr;
    char *hitDepthStr;
    char *readProbStr;
    char *sizeMeanStr;
    char *sizeCVarStr;
    char *processNumStr;
    char *sharingStr;
    char *cpuThinkStr;
    char *alignProbStr;
    char *alignQuantaStr;
    char *seqProbStr;

    int noRefine;

    char tmpString[1000];

    void optionInit();
    void *malloc();
    int fileNumFunc();

    alignQuantaStr = malloc(STRLENGTH);

    optionInit(optionArray+0, OPT_STRING, "d",
	(char *) &(specPtr->dirName), "directory to access");
    optionInit(optionArray+1, OPT_INT, "m", (char *) maxRunTimePtr,
	"max time of each run (seconds, int)");
    optionInit(optionArray+2, OPT_INT, "se", (char *) &(specPtr->seed),
	"random seed (int)");
    optionInit(optionArray+3, OPT_STRING, "f", (char *) fileServerPtr,
	"file server name");

    optionInit(optionArray+4, OPT_DOC, "", (char *) NULL,
	"format for variable parameters:");
    optionInit(optionArray+5, OPT_DOC, "", (char *) NULL,
	"start; min-; -max; min-max; min-start-; -start-max; min-start-max");

    /* starting values */
    optionInit(optionArray+6, OPT_STRING, "u", (char *) &uniqueBytesStr,
	"uniqueBytes--number of unique bytes transferred (KB, double)");
    /*
    optionInit(optionArray+7, OPT_STRING, "re", (char *) &reUseStr,
	"reuse--how many times each byte is used (double)");
    */
    optionInit(optionArray+7, OPT_DOC, "", (char *) NULL,
	""); /* placeholder for reUse */
    optionInit(optionArray+8, OPT_STRING, "h", (char *) &hitDepthStr,
	"hit depth--average LRU depth (fraction of uniqueBytes)");
    optionInit(optionArray+9, OPT_STRING, "r", (char *) &readProbStr,
	"fraction of reads (double)");
    optionInit(optionArray+10, OPT_STRING, "s", (char *) &sizeMeanStr,
	"mean request size (KB, double)");
    optionInit(optionArray+11, OPT_STRING, "sc", (char *) &sizeCVarStr,
	"size coefficient of variation (double)");
    optionInit(optionArray+12, OPT_STRING, "p", (char *) &processNumStr,
	"number of processes (int)");
    optionInit(optionArray+13, OPT_STRING, "sh", (char *) &sharingStr,
	"how much sharing (double)");
    optionInit(optionArray+14, OPT_STRING, "c", (char *) &cpuThinkStr,
	"cpu think time in between I/O (ms, double)");
    optionInit(optionArray+15, OPT_STRING, "ap", (char *) &alignProbStr,
	"fraction of aligned requests (double)");
    optionInit(optionArray+16, OPT_STRING, "a", (char *) &alignQuantaStr,
	"quanta of alignment (system blocksize) for most requests (KB, double)");
    optionInit(optionArray+17, OPT_STRING, "q", (char *) &seqProbStr,
	"fraction of sequential accesses (double)");
    optionInit(optionArray+18, OPT_STRING, "ri", (char *) readResultFile,
	"file of old results to read in");
    optionInit(optionArray+19, OPT_TRUE, "nn", (char *) noNarrowPtr,
	"don't try to narrow the parameter range");
    optionInit(optionArray+20, OPT_TRUE, "nr", (char *) &noRefine,
	"don't try to refine the knee point");
    optionInit(optionArray+21, OPT_INT, "ra", (char *) randomExploreNumPtr,
	"take n random points throughout the parameter space");
    optionInit(optionArray+22, OPT_INT, "or", (char *) orthogonalExploreNumPtr,
	"explore full orthogonal space with n points per dimension");
    optionInit(optionArray+23, OPT_INT, "ke", (char *) kneeExploreNumPtr,
	"take n random points, varying 1 parameter from knee point");
    optionInit(optionArray+24, OPT_STRING, "du", (char *) compareFilePtr,
	"file of results to duplicate");
    optionInit(optionArray+25, OPT_TRUE, "ua", (char *) useAllResultsFlagPtr,
	"enable using all previous results immediately");
    optionInit(optionArray+26, OPT_INT, "mi", (char *) minRunTimePtr,
	"minimum running time of a single workload (seconds, int)");
    optionInit(optionArray+27, OPT_FALSE, "nw", (char *) warmStartFlagPtr,
	"no warm start");
    optionInit(optionArray+28, OPT_FALSE, "np", (char *) findPlateauPtr,
	"don't find and graph plateaus in uniqueBytes");
    optionInit(optionArray+29, OPT_FALSE, "nf", (char *) flushPossiblePtr,
	"not able to flush file cache with flushClientServer");
    optionInit(optionArray+30, OPT_STRING, "fu", (char *) focalUnique,
	"comma separated list of focal points for uniqueBytes");
    optionInit(optionArray+31, OPT_INT, "n", (char *) numExplorePtr,
	"number of points per graph");

    /* set up default values */
    copystring(specPtr->dirName,"./files");
    copystring(*fileServerPtr,"");
    *maxRunTimePtr = 3600;
    specPtr->seed = 11;
    copystring(*readResultFile, "");
    copystring(*compareFilePtr, "");
    copystring(*focalUnique, "");
    (*noNarrowPtr) = 0;
    noRefine = 0;
    (*randomExploreNumPtr) = (*orthogonalExploreNumPtr) =
	(*kneeExploreNumPtr) = 0;
    (*useAllResultsFlagPtr) = 0;

    (*minRunTimePtr) = 60;
#if defined(SPRITE)
    (*minRunTimePtr) = 240; /* Sprite seems to take longer to stabilize */
#endif
#if defined(SUN_OS)
    (*minRunTimePtr) = 30; /* SunOS doesn't take so long to stabilize */
#endif

    (*warmStartFlagPtr) = 1;
    (*findPlateauPtr) = 1;
    (*flushPossiblePtr) = 1;
    (*numExplorePtr) = 10;

    copystring(uniqueBytesStr,"1000-5000-10000");
    copystring(reUseStr,"1.2-2-100000");
/* ???
    copystring(hitDepthStr,".1-.5-.9"); not 0-1 because they're too hard for
					    specWl to achieve
*/
    /* ??? testing adaptWl with hitDepth fixed at .5 */
    copystring(hitDepthStr,".5-.5-.5"); /* not 0-1 because they're too hard for
					    specWl to achieve */
    copystring(readProbStr,"0-.5-1");
    sprintf(tmpString, "%lf-10-100", 2.0 * MINSIZE/1024.0);
    copystring(sizeMeanStr, tmpString);
    copystring(sizeCVarStr,"1-1-1");
    copystring(processNumStr,"1-4-10");
    copystring(sharingStr,"1.01-1.01-1.01");
    copystring(cpuThinkStr,"0-0-0");
    copystring(alignProbStr,"1-1-1");
    sprintf(alignQuantaStr,"%lf-%lf-%lf", MYBUFSIZ/1024.0, MYBUFSIZ/1024.0,
	MYBUFSIZ/1024.0);
    copystring(seqProbStr,"0-.5-1");

    analyzeOptionStrings(uniqueBytesStr, reUseStr, hitDepthStr, readProbStr,
	sizeMeanStr, sizeCVarStr, processNumStr, sharingStr, cpuThinkStr,
	alignProbStr, alignQuantaStr, seqProbStr, minSpecPtr, maxSpecPtr,
	specPtr);

    Opt_Parse(argc, argv, optionArray, Opt_Number(optionArray), 0);

    analyzeOptionStrings(uniqueBytesStr, reUseStr, hitDepthStr, readProbStr,
	sizeMeanStr, sizeCVarStr, processNumStr, sharingStr, cpuThinkStr,
	alignProbStr, alignQuantaStr, seqProbStr, minSpecPtr, maxSpecPtr,
	specPtr);

    if (noRefine) {
	(*refineIterPtr) = 1;
    }

    if ((*orthogonalExploreNumPtr) > 0 || (*randomExploreNumPtr) > 0 || (*kneeExploreNumPtr) > 0 || (*compareFilePtr)[0] != '\0') {
	(*refineIterPtr) = 0;
	(*noNarrowPtr) = 1;
    }

    if (maxSpecPtr->sharing > 1) {
	if (fileNumFunc(maxSpecPtr->processNum, maxSpecPtr->sharing) > FILENUMMAX) {
	    printf("potential for too many files under one process\n");
	    exit(1);
	}
    }

    if ( (*numExplorePtr) <=1 ) {
	printf("error: only %d points per graph, must have at least 2 (see option -n)\n", *numExplorePtr);
	exit(1);
    }
    
    /*
    if (specPtr->reUse<1) {
	printf("error: reUse=%lf, must be at least 1\n", specPtr->reUse);
	exit(1);
    }

    if (specPtr->hitDepth>1) {
	printf("error: hitDepth=%lf, should be less than 1\n", specPtr->hitDepth);
	exit(1);
    }

    if (specPtr->sharing>1) {
	printf("error: sharing=%lf\n", specPtr->sharing);
	exit(1);
    }

    if (sizeMeanKB <= 0) {
	printf("error: sizeMeanKB = %lf\n", sizeMeanKB);
	exit(1);
    }

    if (uniqueBytesKB <= 0) {
	printf("error: uniqueBytesKB = %lf\n", uniqueBytesKB);
	exit(1);
    }
    */

}

analyzeOptionStrings(uniqueBytesStr, reUseStr, hitDepthStr, readProbStr,
	sizeMeanStr, sizeCVarStr, processNumStr, sharingStr, cpuThinkStr,
	alignProbStr, alignQuantaStr, seqProbStr, minSpecPtr, maxSpecPtr,
	specPtr)
    
    char *uniqueBytesStr;
    char *reUseStr;
    char *hitDepthStr;
    char *readProbStr;
    char *sizeMeanStr;
    char *sizeCVarStr;
    char *processNumStr;
    char *sharingStr;
    char *cpuThinkStr;
    char *alignProbStr;
    char *alignQuantaStr;
    char *seqProbStr;

    WLPARAM *minSpecPtr;
    WLPARAM *maxSpecPtr;
    WLPARAM *specPtr;
{
    double minTmp, startTmp, maxTmp;

    minTmp = minSpecPtr->uniqueBytes/1024.0;
    startTmp = specPtr->uniqueBytes/1024.0;
    maxTmp = maxSpecPtr->uniqueBytes/1024.0;

    analyzeOneOption(uniqueBytesStr, &minTmp, &startTmp, &maxTmp, UNIQUEBYTES);

    minSpecPtr->uniqueBytes = minTmp * 1024.0;
    specPtr->uniqueBytes = startTmp * 1024.0;
    maxSpecPtr->uniqueBytes = maxTmp * 1024.0;

    analyzeOneOption(reUseStr, &(minSpecPtr->reUse), &(specPtr->reUse),
	&(maxSpecPtr->reUse), REUSE);

    analyzeOneOption(hitDepthStr, &(minSpecPtr->hitDepth),
	&(specPtr->hitDepth), &(maxSpecPtr->hitDepth), HITDEPTH);

    analyzeOneOption(readProbStr, &(minSpecPtr->readProb),
	&(specPtr->readProb), &(maxSpecPtr->readProb), READPROB);

    minTmp = minSpecPtr->sizeMean/1024.0;
    startTmp = specPtr->sizeMean/1024.0;
    maxTmp = maxSpecPtr->sizeMean/1024.0;

    analyzeOneOption(sizeMeanStr, &minTmp, &startTmp, &maxTmp, SIZEMEAN);

    minSpecPtr->sizeMean = minTmp * 1024.0;
    specPtr->sizeMean = startTmp * 1024.0;
    maxSpecPtr->sizeMean = maxTmp * 1024.0;

    analyzeOneOption(sizeCVarStr, &(minSpecPtr->sizeCVar),
	&(specPtr->sizeCVar), &(maxSpecPtr->sizeCVar), SIZECVAR);

    minTmp = minSpecPtr->processNum;
    startTmp = specPtr->processNum;
    maxTmp = maxSpecPtr->processNum;

    analyzeOneOption(processNumStr, &minTmp, &startTmp, &maxTmp, PROCESSNUM);

    minSpecPtr->processNum = minTmp;
    specPtr->processNum = startTmp;
    maxSpecPtr->processNum = maxTmp;

    analyzeOneOption(sharingStr, &(minSpecPtr->sharing),
	&(specPtr->sharing), &(maxSpecPtr->sharing), SHARING);

    analyzeOneOption(cpuThinkStr, &(minSpecPtr->cpuThink),
	&(specPtr->cpuThink), &(maxSpecPtr->cpuThink), CPUTHINK);

    analyzeOneOption(alignProbStr, &(minSpecPtr->alignProb),
	&(specPtr->alignProb), &(maxSpecPtr->alignProb), ALIGNPROB);

    minTmp = minSpecPtr->alignQuanta/1024.0;
    startTmp = specPtr->alignQuanta/1024.0;
    maxTmp = maxSpecPtr->alignQuanta/1024.0;

    analyzeOneOption(alignQuantaStr, &minTmp, &startTmp, &maxTmp, ALIGNQUANTA);

    minSpecPtr->alignQuanta = minTmp * 1024.0;
    specPtr->alignQuanta = startTmp * 1024.0;
    maxSpecPtr->alignQuanta = maxTmp * 1024.0;

    analyzeOneOption(seqProbStr, &(minSpecPtr->seqProb),
	&(specPtr->seqProb), &(maxSpecPtr->seqProb), SEQPROB);
    
}

analyzeOneOption(str, minPtr, startPtr, maxPtr, whichParam)
    char *str;
    double *minPtr;
    double *startPtr;
    double *maxPtr;
    int whichParam;
{
    /* analyze one option */
    int numTok;

    char *convertParamStr();
    double atof();

    /* test for null string */
    if (str[0] == '\0') {
	return;
    }

    numTok = numTokens(str, SEP);
    if (numTok == 0) {
	/* no dashes */
	*startPtr = atof(str);
	/* printf("start = %lf\n", *startPtr); */
	if ((*startPtr) > (*maxPtr)) {
	    printf("warning for %s: start > max.  adjusting max\n",
		convertParamStr(whichParam));
	    (*maxPtr) = (*startPtr);
	}
	if ((*startPtr) < (*minPtr)) {
	    printf("warning for %s: start < min.  adjusting min\n",
		convertParamStr(whichParam));
	    (*minPtr) = (*startPtr);
	}
    } else if (numTok == 1) {
	/* one dash */
	if (str[0] == SEP) {
	    /* dash is in the beginning */
	    sscanf(str, "-%lf", maxPtr);
	} else if (str[strlen(str)-1] == SEP) {
	    /* dash is at the end */
	    sscanf(str, "%lf-", minPtr);
	} else {
	    /* dash is in the middle */
	    sscanf(str, "%lf-%lf", minPtr, maxPtr);
	}
    } else if (numTok == 2) {
	if (str[0] == SEP) {
	    /* dash is in the beginning */
	    sscanf(str, "-%lf-%lf", startPtr, maxPtr);
	    if ((*startPtr) < (*minPtr)) {
		printf("warning for %s: start < min.  adjusting min\n",
		    convertParamStr(whichParam));
		(*minPtr) = (*startPtr);
	    }
	} else if (str[strlen(str)-1] == SEP) {
	    /* dash is at the end */
	    sscanf(str, "%lf-%lf-", minPtr, startPtr);
	    if ((*startPtr) > (*maxPtr)) {
		printf("warning for %s: start > max.  adjusting max\n",
		    convertParamStr(whichParam));
		(*maxPtr) = (*startPtr);
	    }
	} else {
	    /* dash is in the middle */
	    sscanf(str, "%lf-%lf-%lf", minPtr, startPtr, maxPtr);
	}
    } else {
	printf("error in analyzeOneOption: too many %c characters in %s\n",
	    SEP, str);
	exit(1);
    }

    /* make sure min, start, and max are ordered correctly */
    if ((*maxPtr) < (*minPtr)) {
	printf("warning for %s: max < min.  adjusting max\n",
	    convertParamStr(whichParam));
	(*maxPtr) = (*minPtr);
    }

    if ((*startPtr) < (*minPtr)) {
	printf("warning for %s: start < min.  adjusting start\n",
	    convertParamStr(whichParam));
	(*startPtr) = (*minPtr);
    }

    if ((*startPtr) > (*maxPtr)) {
	printf("warning for %s: start > max.  adjusting start\n",
	    convertParamStr(whichParam));
	(*startPtr) = (*maxPtr);
    }
}

int numTokens(str, token)
    char *str;
    char token;
{
    /* counts how many occurences of token occur in str */
    int i;
    int num;

    num=0;
    for (i=0; str[i]!='\0'; i++) {
	if (str[i] == token) {
	    num++;
	}
    }
    return(num);
}

printWlParamRange(minSpecPtr, maxSpecPtr, specPtr, maxRunTime)
    WLPARAM *minSpecPtr;
    WLPARAM *maxSpecPtr;
    WLPARAM *specPtr;
    int maxRunTime;
{
    printf("directory %s\n", specPtr->dirName);
    printf("max run time of each run %d seconds\n", maxRunTime);
    printf("random seed %d\n", specPtr->seed);
    printf("uniqueBytes: %lf - %lf - %lf KB\n", minSpecPtr->uniqueBytes/1024.0,
	specPtr->uniqueBytes/1024.0, maxSpecPtr->uniqueBytes/1024.0);
    printf("reUse: %lf - %lf - %lf\n", minSpecPtr->reUse, specPtr->reUse,
	maxSpecPtr->reUse);
    printf("hitDepth: %lf - %lf - %lf\n", minSpecPtr->hitDepth,
	specPtr->hitDepth, maxSpecPtr->hitDepth);
    printf("readFrac: %lf - %lf - %lf\n", minSpecPtr->readProb,
	specPtr->readProb, maxSpecPtr->readProb);
    printf("sizeMean: %lf - %lf - %lf KB\n", minSpecPtr->sizeMean/1024.0,
	specPtr->sizeMean/1024.0, maxSpecPtr->sizeMean/1024.0);
    printf("sizeCVar: %lf - %lf - %lf\n", minSpecPtr->sizeCVar,
	specPtr->sizeCVar, maxSpecPtr->sizeCVar);
    printf("processNum: %d - %d - %d\n", minSpecPtr->processNum,
	specPtr->processNum, maxSpecPtr->processNum);
    printf("sharing: %lf - %lf - %lf\n", minSpecPtr->sharing, specPtr->sharing,
	maxSpecPtr->sharing);
    printf("cpuThink: %lf - %lf - %lf (ms)\n", minSpecPtr->cpuThink,
	specPtr->cpuThink, maxSpecPtr->cpuThink);
    printf("alignFrac: %lf - %lf - %lf\n", minSpecPtr->alignProb,
	specPtr->alignProb,
	maxSpecPtr->alignProb);
    printf("alignQuanta: %lf - %lf - %lf KB\n", minSpecPtr->alignQuanta/1024.0,
	specPtr->alignQuanta/1024.0, maxSpecPtr->alignQuanta/1024.0);
    printf("seqFrac: %lf - %lf - %lf\n", minSpecPtr->seqProb, specPtr->seqProb,
	maxSpecPtr->seqProb);
}
