#include <stdio.h>
#include "adaptWl.h"
#include <math.h>

readResultAll(result, resultNumPtr, fileName, printFlag)
    WLRESULT *result;
    int *resultNumPtr;
    char *fileName;
    int printFlag;
{
    char tmpString[1000];
    char line[1000];
    FILE *fp;
    int i;
    char *status;

    printf("reading results in from %s\n", fileName);
    if ( (*resultNumPtr) != 0) {
	printf("error in readResultAll: resultNum != 0, = %d\n", *resultNumPtr);
	exit(1);
    }

    /* open file to read in old results */
    sprintf(tmpString, "%s", fileName);
    fp = fopen(fileName, "r");
    if (fp == NULL) {
	perror("error in readResultAll: fopen");
	exit(1);
    }

    do {
	i=0;
	/* look for --- run */
	sprintf(tmpString, "--- run ", *resultNumPtr);
	if (printFlag) {
	    printf("looking for %s\n", tmpString);
	}
	do {
	    status = fgets(line, 1000, fp);
	    /* printf("%d: @@%s", i, line); */
	    i++;
	} while (strncmp(tmpString, line, strlen(tmpString)) && status!=NULL);
	if (printFlag) {
	    printf("skipped %d lines\n",i);
	}

	if (status != NULL) {
	    readResult(fp, result+(*resultNumPtr));
	    if (printFlag) {
		printResult(&(result[*resultNumPtr]), *resultNumPtr);
	    }
	    (*resultNumPtr)++;
	}
    } while (status != NULL);

    printf("end of reading in old results\n");

    fclose(fp);
}

readResult(fp, resultPtr)
    FILE *fp;
    WLRESULT *resultPtr;
{
    int status;
    double tmp1, tmp2;
    char char1, char2, char3, char4;

    status = fscanf(fp, "uniqueBytes %lf KB (%lf)\n", &tmp1, &tmp2);
    if (status != 2) {
	printf("error in readResult1: read %d items\n", status);
	exit(1);
    }
    resultPtr->param.uniqueBytes = tmp1 * 1024;
    resultPtr->target.uniqueBytes = tmp2 * 1024;

    status = fscanf(fp, "reUse %lf (%lf)\n", &(resultPtr->param.reUse),
	&(resultPtr->target.reUse));
    if (status != 2) {
	printf("error in readResult2: read %d items\n", status);
	exit(1);
    }
    status = fscanf(fp, "hitDepth %lf (%lf)\n", &(resultPtr->param.hitDepth),
	&(resultPtr->target.hitDepth));
    if (status != 2) {
	printf("error in readResult3: read %d items\n", status);
	exit(1);
    }
    /* readProb or readFrac */
    status = fscanf(fp, "read%c%c%c%c %lf (%lf)\n", &char1, &char2, &char3,
	&char4, &(resultPtr->param.readProb), &(resultPtr->target.readProb));
    if ( (char1!='P' || char2!='r' || char3!='o' || char4!='b') &&
    	 (char1!='F' || char2!='r' || char3!='a' || char4!='c') ) {
	printf("error in readResult4: not readProb or readFrac\n");
	exit(1);
     }

    if (status != 6) {
	printf("error in readResult4: read %d items\n", status);
	exit(1);
    }

    status = fscanf(fp, "sizeMean %lf KB (%lf)\n", &tmp1, &tmp2);
    if (status != 2) {
	printf("error in readResult5: read %d items\n", status);
	exit(1);
    }
    resultPtr->param.sizeMean = tmp1 * 1024;
    resultPtr->target.sizeMean = tmp2 * 1024;

    status = fscanf(fp, "sizeCVar %lf (%lf)\n", &(resultPtr->param.sizeCVar),
	&(resultPtr->target.sizeCVar));
    if (status != 2) {
	printf("error in readResult6: read %d items\n", status);
	exit(1);
    }
    status = fscanf(fp, "processNum %d (%d)\n", &(resultPtr->param.processNum),
	&(resultPtr->target.processNum));
    if (status != 2) {
	printf("error in readResult7: read %d items\n", status);
	exit(1);
    }
    status = fscanf(fp, "sharing %lf (%lf)\n", &(resultPtr->param.sharing),
	&(resultPtr->target.sharing));
    if (status != 2) {
	printf("error in readResult8: read %d items\n", status);
	exit(1);
    }

    status = fscanf(fp, "seq%c%c%c%c %lf (%lf)\n", &char1, &char2, &char3,
	&char4, &(resultPtr->param.seqProb), &(resultPtr->target.seqProb));
    if ( (char1!='P' || char2!='r' || char3!='o' || char4!='b') &&
    	 (char1!='F' || char2!='r' || char3!='a' || char4!='c') ) {
	printf("error in readResult9: not seqProb or seqFrac\n");
	exit(1);
     }
    if (status != 6) {
	printf("error in readResult9: read %d items\n", status);
	exit(1);
    }

    status = fscanf(fp, "alignQuanta %lf KB (%lf)\n", &tmp1, &tmp2);
    if (status != 2) {
	printf("error in readResult10: read %d items\n", status);
	exit(1);
    }
    resultPtr->param.alignQuanta = tmp1 * 1024;
    resultPtr->target.alignQuanta = tmp2 * 1024;

    status = fscanf(fp, "align%c%c%c%c %lf (%lf)\n", &char1, &char2, &char3,
	&char4, &(resultPtr->param.alignProb), &(resultPtr->target.alignProb));
    if ( (char1!='P' || char2!='r' || char3!='o' || char4!='b') &&
    	 (char1!='F' || char2!='r' || char3!='a' || char4!='c') ) {
	printf("error in readResult11: not alignProb or alignFrac\n");
	exit(1);
    }
    if (status != 6) {
	printf("error in readResult11: read %d items\n", status);
	exit(1);
    }
    status = fscanf(fp, "seed %d\n", &(resultPtr->target.seed));
    if (status != 1) {
	printf("error in readResult12: read %d items\n", status);
	exit(1);
    }

    status = fscanf(fp, "throughput %lf MB/s\n", &(resultPtr->perf.throughput));
    if (status != 1) {
	printf("error in readResult13: read %d items\n", status);
	exit(1);
    }
    status = fscanf(fp, "avResponseTime %lf ms\n", &(resultPtr->perf.avResponseTime));
    if (status != 1) {
	printf("error in readResult14: read %d items\n", status);
	exit(1);
    }
    status = fscanf(fp, "cpuThink %lf ms (%lf)\n", &(resultPtr->perf.cpuThink),
	&(resultPtr->target.cpuThink));
    if (status != 2) {
	printf("error in readResult15: read %d items\n", status);
	exit(1);
    }
}

printResultAll(resultPtr, resultNum)
    WLRESULT *resultPtr;
{
    int i;

    printf("========================================================\n");
    printf("total of %d runs\n", resultNum);
    for (i=0; i<resultNum; i++) {
	printResult(resultPtr+i, i);
    }
}

printResult(resultPtr, runNumber)
    WLRESULT *resultPtr;
    int runNumber;
{
    printf("--- run %d ---\n", runNumber);
    printf("uniqueBytes %lf KB (%lf)\n", resultPtr->param.uniqueBytes/1024.0,
	resultPtr->target.uniqueBytes/1024.0);
    printf("reUse %lf (%lf)\n", resultPtr->param.reUse,
	resultPtr->target.reUse);
    printf("hitDepth %lf (%lf)\n", resultPtr->param.hitDepth,
	resultPtr->target.hitDepth);
    printf("readFrac %lf (%lf)\n", resultPtr->param.readProb,
	resultPtr->target.readProb);
    printf("sizeMean %lf KB (%lf)\n", resultPtr->param.sizeMean/1024.0,
	resultPtr->target.sizeMean/1024.0);
    printf("sizeCVar %lf (%lf)\n", resultPtr->param.sizeCVar,
	resultPtr->target.sizeCVar);
    printf("processNum %d (%d)\n", resultPtr->param.processNum,
	resultPtr->target.processNum);
    printf("sharing %lf (%lf)\n", resultPtr->param.sharing,
	resultPtr->target.sharing);
    printf("seqFrac %lf (%lf)\n", resultPtr->param.seqProb,
	resultPtr->target.seqProb);
    printf("alignQuanta %lf KB (%lf)\n", resultPtr->param.alignQuanta/1024.0,
	resultPtr->target.alignQuanta/1024.0);
    printf("alignFrac %lf (%lf)\n", resultPtr->param.alignProb,
	resultPtr->target.alignProb);
    printf("seed %d\n", resultPtr->target.seed);

    printf("throughput %lf MB/s\n", resultPtr->perf.throughput);
    printf("avResponseTime %lf ms\n", resultPtr->perf.avResponseTime);
    printf("cpuThink %lf ms (%lf)\n", resultPtr->perf.cpuThink,
	resultPtr->target.cpuThink);
    printf("\n");
}
