/*
 * Converted from the C++ library.
 */

#ifndef _STAT_H
#define _STAT_H

#include <math.h>

typedef struct{
    int		n;
    double	sumX;
    double	sumX2;
    double	min;
    double	max;
} Stat;

typedef struct{		/* Subclass of Stat */
    Stat	stat;
    int		batchSize;
    int		batchN;
    double	batchSumX;
} BatchStat;

#define MAX_AUTO_COV_DIST	10

typedef struct{		/* Subclass of Stat */
    Stat	stat;
    double	sumXY[MAX_AUTO_COV_DIST];
    double	firstX[MAX_AUTO_COV_DIST];
    double	lastX[MAX_AUTO_COV_DIST];
    int		batchSize;
    int		batchN;
    double	batchSumX;
    int		autoDist;
} AutoStat;

#define MAX_RAND_BIN	10

double tval();
void InitStat();
void InitBatchStat();
void InitAutoStat();
void AddStat();
void AddBatchStat();
void AddAutoStat();
int NStat();
double AveStat();
double VarStat();
double VarMeanAutoStat();
double SDStat();
double SEStat();
double SEAutoStat();
double ConfStat();
double ConfAutoStat();
void AddStatStat();

#endif _STAT_H
