#include <stdio.h>
#include "adaptWl.h"
#include "string.h"
/* #include "strings.h" */

timeStamp()
{
    char tmpString[1000];
    sprintf(tmpString, "date");
    mySystem(tmpString);
#ifdef SPRITE
    sprintf(tmpString, "date > /dev/syslog");
    mySystem(tmpString);
#endif
}

runSpecWl(specPtr)
    WLPARAM *specPtr;
{
    char tmpString[1000];

    int skipAndCopy();

    printf("\n");
    sprintf(tmpString, "specWl -d %s -u %lf -re %lf -h %lf -r %lf -s %lf -sc %lf -p %d -sh %lf -c %lf -ap %lf -a %lf -q %lf -se %d",
	specPtr->dirName,
	specPtr->uniqueBytes/1024.0,
	specPtr->reUse,
	specPtr->hitDepth,
	specPtr->readProb,
	specPtr->sizeMean/1024.0,
	specPtr->sizeCVar,
	specPtr->processNum,
	specPtr->sharing,
	specPtr->cpuThink,
	specPtr->alignProb,
	specPtr->alignQuanta/1024.0,
	specPtr->seqProb,
	specPtr->seed);
    /*
    sprintf(tmpString, "specWl -help");
    */

    timeStamp();

    mySystem(tmpString);
    printf("\n");

}

runDoWl(adaptDirName, maxRunTime, fileServer, warmStartFlag, numScriptIter)
    char *adaptDirName;
    int maxRunTime;
    char *fileServer;
    int warmStartFlag;
    int numScriptIter;
{
    char tmpString[1000];

/* #ifndef RUNREMOTE */
    if (warmStartFlag) {
	sprintf(tmpString, "doWl -d %s -m %d -w -n %d", adaptDirName,
	    maxRunTime, numScriptIter);
    } else {
	sprintf(tmpString, "doWl -d %s -m %d -n %d", adaptDirName, maxRunTime,
	    numScriptIter);
    }

    /* sprintf(tmpString, "rsh %s 'echo $path; doWl -d %s -m %d'",
	    "raid1", adaptDirName, maxRunTime); */
    /*
    sprintf(tmpString, "doWl -help");
    */

    /*
    if (!warmStartFlag) {
	flushClientServer(fileServer, adaptDirName);
    }
    */
    timeStamp();

    mySystem(tmpString);
    printf("\n");

    timeStamp();

}

flushClientServer(fileServer, dirName)
    char *fileServer;
    char *dirName;
{
    char tmpString[200];

#ifdef SPRITE
    sprintf(tmpString, "flushClientServer %s", fileServer);
#else
    sprintf(tmpString, "flushClientServer %s", dirName);
#endif
    mySystem(tmpString);
}



getDoWlResult(perf, dirName)
    WLPERF *perf;
    char *dirName;
{
    char tmpFileName[100];
    FILE *tmpFilePtr;

    sprintf(tmpFileName, "%s/doWl.adaptWl", dirName);
    tmpFilePtr = fopen(tmpFileName, "r");
    if (tmpFilePtr == NULL) {
	perror("error in getDoWlResult: fopen");
	exit(1);
    }
    fscanf(tmpFilePtr, "throughput %lf\n", &(perf->throughput));
    fscanf(tmpFilePtr, "avResponseTime %lf\n", &(perf->avResponseTime));
    fscanf(tmpFilePtr, "cpuThink %lf\n", &(perf->cpuThink));
    fscanf(tmpFilePtr, "duration %lf\n", &(perf->duration));
    fclose(tmpFilePtr);
}

mySystem(str)
    char *str;
{
    int status;

    fflush(stdout);
    fflush(stderr);
    status = system(str);
    if (status != 0) {
	printf("error in system call %s, returned %d\n", str, status);
	exit(1);
    }
}
