#include <stdio.h>
#include "specWl.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/file.h>
#include <errno.h>
#include <string.h>

#ifndef S_ISLNK
#define S_ISLNK( mode )         (((mode) & S_IFMT) == S_IFLNK)
#endif

#ifndef S_ISREG
#define S_ISREG( mode )         (((mode) & S_IFMT) == S_IFREG)
#endif

CHILDCMDFILE childCmdFile[PROCMAX];

initChildParent(specPtr, fileNum, fileSize)
    WLPARAM *specPtr;
    int fileNum;
    unsigned int fileSize;
{
    int i,j;
    int tmpFd;
    char tmpName[FILENAMEMAX];
    char tmpString[FILENAMEMAX];
    FILE *tmpFilePtr;
    int status;
    struct stat statBuf;
    int f;

    int processFileNum();
    int truncate();

    /* name, open, truncate, and initialize child command files */
    for (i=0; i<specPtr->processNum; i++) {
	sprintf(childCmdFile[i].name, "%s/%s.%d.cmd", specPtr->dirName, CHILDFILE, i);
	tmpFd = open(childCmdFile[i].name, O_WRONLY|O_TRUNC|O_CREAT, 0666);
	childCmdFile[i].current = 0;
	if (tmpFd < 0) {
	    perror("error in initChildParent: open");
	    printf("filename was %s\n", childCmdFile[i].name);
	    exit(1);
	}

	/* give a list of files for this run */
	if (specPtr->sharing <= 1) {
	    getDataFileName(tmpName, specPtr->dirName,
		processFileNum(i, fileNum, specPtr->sharing));
	    sprintf(tmpString, "%s %u\n", tmpName, fileSize);
	    status = write(tmpFd, tmpString, strlen(tmpString));
	    if (status != strlen(tmpString)) {
		if (status < 0) {
		    perror("error: write");
		} else {
		    printf("error: only %d bytes written out of %d\n", status,
			strlen(tmpString));
		}
		exit(1);
	    }
	} else {
	    for (j=0; j<fileNum; j++) {

		getDataFileName(tmpName, specPtr->dirName, j);
		sprintf(tmpString, "%s %u\n", tmpName, fileSize);
		status = write(tmpFd, tmpString, strlen(tmpString));
		if (status != strlen(tmpString)) {
		    if (status < 0) {
			perror("error: write");
		    } else {
			printf("error: only %d bytes written out of %d\n", status,
			    strlen(tmpString));
		    }
		    exit(1);
		}
	    }
	}
	close(tmpFd);
    }

    /* give information to the parent of doWl */
    sprintf(tmpName, "%s/%s.cmd", specPtr->dirName, PARENTFILE);
    tmpFilePtr = fopen(tmpName, "w+");
    if (tmpFilePtr == NULL) {
	perror("error: fopen");
	exit(1);
    }
    fprintf(tmpFilePtr, "processNum %d\n", specPtr->processNum);
    fprintf(tmpFilePtr, "filesPerChild %d\n",
	(specPtr->sharing<=1)? 1:fileNum);
    fclose(tmpFilePtr);

    /* see if you need to create the data files */
    for (i=0; i<fileNum; i++) {
	getDataFileName(tmpName, specPtr->dirName, i);
	/* sprintf(tmpName, "%s/%s.%d.data", specPtr->dirName, CHILDFILE, i); */

	f = open(tmpName, O_CREAT|O_WRONLY, 0666);
	if (f<0) {
	    perror("error in initChildParent: open");
	    printf("tmpName=%s\n", tmpName);
	    exit(1);
	}
	if (fstat(f, &statBuf) < 0) {
	    perror("error fstat");
	    exit(1);
	}
	close(f);
	if (S_ISREG(statBuf.st_mode) && statBuf.st_size != fileSize) {
	    /* this data file is not the right size */
	    printf("%s is currently %lf KB--wrong size\n", tmpName,
		statBuf.st_size/1024.0);
	    break;
	}
    }

    if (i<fileNum) {
	/* truncate all data files which haven't been inspected */
	for (j=i; j<FILENUMMAX; j++) {
	    getDataFileName(tmpName, specPtr->dirName, j);

	    status = lstat(tmpName, &statBuf);
	    if (status < 0 && errno != ENOENT) {
		perror("lstat");
		exit(1);
	    }

	    if (status == 0 && S_ISREG(statBuf.st_mode)) {

		status = truncate(tmpName, 0);
		/*
		status = unlink(tmpName);
		*/
		if (status == 0) {
		    printf("truncated %s\n", tmpName);
		}
		if (status < 0 && errno != ENOENT) {
		    perror("error in initChildParent: truncate");
		    printf("tmpName=%s\n", tmpName);
		    exit(1);
		}
	    }
	}

	/* now create the necessary files */
	for (j=i; j<fileNum; j++) {
	    getDataFileName(tmpName, specPtr->dirName, j);
	    /* sprintf(tmpName, "%s/%s.%d.data", specPtr->dirName, CHILDFILE, j); */
	    status = lstat(tmpName, &statBuf);
	    if (status < 0 && errno != ENOENT) {
		perror("lstat");
		exit(1);
	    }

	    createGarbage(tmpName, fileSize);
	}
    }
}

addIO(process, command, file, size, start, waitTime)
    int process;
    char command;
    int file;
    unsigned int size;
    unsigned int start;
    double waitTime;
{
    char tmp[MAXIOCOMMANDLEN];
    sprintf(tmp, "%c %d %u %u %lf\n", command, file, size, start, waitTime);
    if (childCmdFile[process].current + MAXIOCOMMANDLEN >= MYBUFSIZ) {
	printBuf(process);
    }
    sprintf(childCmdFile[process].buffer + childCmdFile[process].current,
		"%s", tmp);
    childCmdFile[process].current += strlen(tmp);
}

printBuf(process)
    int process;
{
    int tmpFd;
    int status;

#ifdef DEBUG
    printf("called printBuf with current=%d\n", childCmdFile[process].current);
#endif
    if (childCmdFile[process].current > 0) {
	tmpFd = open(childCmdFile[process].name, O_WRONLY|O_APPEND, 0666);
	if (tmpFd < 0) {
	    perror("error in printBuf: open");
	    exit(1);
	}
	status = write(tmpFd, childCmdFile[process].buffer,
			childCmdFile[process].current);
	if (status != childCmdFile[process].current) {
	    if (status < 0) {
		perror("error: write");
	    } else {
		printf("error: only %d bytes written\n", status);
	    }
	    exit(1);
	}
	close(tmpFd);

	childCmdFile[process].current = 0;
    }
    return;
}

int processFileNumUnique(process, fileNum, sharing)
    int process;
    int fileNum;
    double sharing;
{
    /* gives the "preferred" file for a process */
    /* note that i%fileNum (ie. child number % number of files) is the
	data file for this child */
    return(process%fileNum);
}

int processFileNum(process, fileNum, sharing)
    int process;
    int fileNum;
    double sharing;
{
    /* pick a data file for this I/O for this process */

    long myRandom();
    /* note that i%fileNum (ie. child number % number of files) is the
	data file for this child (if sharing <= 1) */
    if (sharing <= 1) {
	return(process%fileNum);
    } else {
	return(myRandom()%fileNum);
    }
}

getDataFileName(file, dirName, fileNum)
    char *file;
    char *dirName;
    int fileNum;
{
    char buf[FILENAMEMAX];
    int num; 
    struct stat statBuf;
    int status;

    sprintf(file, "%s/%s.%d.data", dirName, CHILDFILE, fileNum);

    /* printf("followLink called with file = %s\n", file); */

    do {
	/* printf("file name %s\n", file); */

	status = lstat(file, &statBuf);
	if (status < 0) {
	    if (errno == ENOENT) {
		return;
	    }
	    perror("lstat");
	    exit(1);
	}

	/*
	if (S_ISDIR(statBuf.st_mode)) {
	    printf("is directory\n");
	}
	if (S_ISCHR(statBuf.st_mode)) {
	    printf("is character special\n");
	}
	if (S_ISBLK(statBuf.st_mode)) {
	    printf("is block special\n");
	}
	*/

	if (S_ISLNK(statBuf.st_mode)) {
	    num = readlink(file, buf, FILENAMEMAX-1);
	    buf[num] = '\0';

	    /* printf("link to %s\n", buf); */
	    if (buf[0] != '/') {
		printf("error: link to file %s, file not absolute pathname\n",
		    buf);
		exit(1);
	    }
	    strncpy(file, buf, FILENAMEMAX);
	}

    } while (S_ISLNK(statBuf.st_mode));
    /* printf("followLink returning %s\n", file); */
}
