#include <stdio.h>
#include <sys/types.h>
#include <fcntl.h>
#include <sys/file.h>
#include <sys/stat.h>

#define QUANTA 1000000 /* approx. 1 MB */

createGarbage(file, size)
    char *file;
    unsigned int size; /* size in bytes */
{
    int f;
    char *a;
    int i,j;
    int tmp;
    int status;
    struct stat statBuf;

    long randomCompress();
    char *malloc();

    printf("making file %s of size %lf KB\n", file, size/1024.0);

    f = open(file, O_CREAT|O_WRONLY|O_TRUNC, 0666);
    if (f<0) {
	perror("error in createGarbage: open");
	exit(1);
    }

    a= (char *)malloc((unsigned)QUANTA);
    for (j=0; j<QUANTA/sizeof(long); j++) {
	*( (long *)a + j) = randomCompress();
    }
    for (i=size; i>0; i-=QUANTA) {
	tmp = (i>=QUANTA)? QUANTA: i;
	if ((status=write(f,a,tmp)) != tmp) {
	    if (status < 0) {
		perror("error: write in createGarbage");
	    } else {
		printf("error: wrote %d bytes instead of %d\n",
		    status, tmp);
	    }
	    exit(1);
	}
    }
    /* check that the size is correct */
    if (fstat(f, &statBuf) < 0) {
	perror("error fstat");
	exit(1);
    }
    /*
    printf("fstat reports file size of %lf KB\n", statBuf.st_size/1024.0);
    */
    if (size != statBuf.st_size) {
	printf("error: created file of size %u instead of %u\n",
	    statBuf.st_size, size);
	exit(1);
    }
    free(a);
    status = fsync(f);
    if (status < 0) {
	perror("error: fsync");
	printf("error: fsync in createGarbage for file %s\n", file);
    }
    close(f);
}

long randomCompress()
{
    static int old=0;
    int decide;

    long myRandom();

    decide=myRandom()%4;

    if (decide < 2) {
	return(old);
    } else if (decide == 2) {
	return((old=(myRandom()%(1024*256)) ));
    } else {
	return((old=(myRandom()%64) ));
    }
}
