#include <math.h>
#include "specWl.h"

#define MISSTRIES 100
#define MAX(a,b) ( ( (a) > (b) ) ? (a) : (b)  )
#define MIN(a,b) ( ( (a) < (b) ) ? (a) : (b)  )

unsigned int getMiss(size, fileSize, file, alignQuanta, alignProb)
    unsigned int size;
    unsigned int fileSize;
    int file;
    unsigned int alignQuanta;
    double alignProb;
{
    /* return the starting address for a miss */

    unsigned int start, end;
    unsigned int startSave, endSave;

    unsigned int findFit();

    int i;

    /* try MISSTRIES times to get a location that hasn't been
	used before */
    /* look through the address 2-3 tree (of used addresses)--
	pick a random address (do a random walk through the tree),
	then search for that leaf's left neighbor (by going up
	the tree as little as possible and going down one branch
	to the left, then take all right branches).  Return the
	extent in between these two leaves.  Then we can choose
	within the extent (randomly placing the request within the
	extent).  If the search fails (ie. you're at the left-most
	leaf of the address tree, the extent is 0-the first leaf's
	starting address.  */

    /* find the first miss address that's large enough to encompass the
	request.  If there are none, then return the largest one found in
	MISSTRIES tries */
    i=0;
    do {
	findMissAddress(&start, &end, file, fileSize-1);
	/*
	printf("returned from findMissAddress with extent [%u, %u]\n",
	    start, end);
	*/
	if ( i == 0 || (end > start && (end-start+1) > (endSave-startSave+1)) ) {
	    startSave = start;
	    endSave = end;
	}
	i++;
    } while ( (end < start || (end-start+1) < size) && i<MISSTRIES);
    /*   note that I could try to not use up the big unused area, but rather
	    try to fit the miss in a smaller region (use size/2 instead of
	    size ) */

    if (endSave < startSave ) {
	/* wasn't able to find any miss addresses */
	/* pick from the whole file */
#ifdef DEBUG
	printf("couldn't find any good miss addresses\n");
#endif
	startSave = 0;
	endSave = fileSize-1;
    }

    start = findFit(startSave, endSave, size, fileSize-1, alignQuanta,
		    alignProb);

    return (start);
}

unsigned int getHit(hitFlagPtr, hitDepthBytes, size, fileSize, uniqueBytes, file,
		    alignQuanta, alignProb)
    int *hitFlagPtr;
    double hitDepthBytes;
    unsigned int size;
    unsigned int fileSize;
    unsigned int uniqueBytes;
    int file;
    unsigned int alignQuanta;
    double alignProb;
{
    /* decide where we want the request to hit (use the normal
    distribution function).  Then walk the lru tree for the
    address at that stack distance.  Take the lru leaf that is
    returned.  If it's not the right file, then search for its
    right neighbor (same method as the address tree above);
    then search for its left neighbor.  Don't forget to
    test for failure (e.g. if you're all the way to the left
    of the lru tree).  If that happens, do a miss (set hitFlag=0)*/

    unsigned int bytesAhead;
    unsigned int start;
    unsigned int end;

    double normalChop();
    double bern();
    unsigned int findFit();

    if (hitDepthBytes > uniqueBytes) {
	printf("error: hitDepthBytes (%lf) > uniqueBytes (%u)\n",
	    hitDepthBytes, uniqueBytes);
	exit(1);
    }

    /*
    bytesAhead = (unsigned int) normalChop(hitDepthBytes,
			(double) MIN(hitDepthBytes, uniqueBytes-1-hitDepthBytes),
			0.0, (double)uniqueBytes-1);
    printf("bytesAhead (returned from normalChop) = %u\n", bytesAhead);
    */
    bytesAhead = (unsigned int) bern(hitDepthBytes,
			    MIN(hitDepthBytes, uniqueBytes-1-hitDepthBytes),
			    0.0, (double)uniqueBytes-1);
#ifdef DEBUG
    printf("bytesAhead (returned from bern) = %u\n", bytesAhead);
#endif


    /* adjust the bytesAhead for this request's bytes */
    if (bytesAhead < size/2) {
	bytesAhead = 0;
    } else {
	bytesAhead -= size/2;
    }
#ifdef DEBUG
    printf("trying to find a request around bytesAhead %u\n", bytesAhead);
#endif

    findHitAddress(&start, &end, file, size, bytesAhead);
#ifdef DEBUG
    printf("returned from findHitAddress with extent [%u, %u]\n",
	start, end);
#endif

    if (end < start) {
	*hitFlagPtr = 0;
	return(0);
    }

    start = findFit(start, end, size, fileSize-1, alignQuanta, alignProb);
    return(start);
}

unsigned int findFit(start, end, size, maxAddress, alignQuanta, alignProb)
    unsigned int start;
    unsigned int end;
    unsigned int size;
    unsigned int maxAddress;
    unsigned int alignQuanta;
    double alignProb;
{
    /* given an extent and a size to fit into that extent, move the request
	around randomly within (or partially outside of) the extent */

    unsigned int length; /* length of extent to fit in */
    unsigned int startTmp;
    unsigned int startAlign;

    int prob();
    long myRandom();
    double round();

    length = end - start + 1;

    /*
    printf("called findFit to fit an extent of size %u into [%u, %u]\n",
	size, start, end);
    */

    if (start > maxAddress || end > maxAddress) {
	printf("error in findFit: calling address(es) too large, start=%u, end=%u, maxAddress=%u\n",
	    start, end, maxAddress);
	exit(1);
    }

    if (length < size) {
	/* modify start and end, making it big enough for the request */
	if (start >= (size-length)) {
	    start = start - (size - length);
	} else {
	    start = 0;
	}
	if (maxAddress - end >= (size - length) ) {
	    end = end + (size - length);
	} else {
	    end = maxAddress;
	}
    }

    length = end - start + 1;

    /* printf("...now try to fit into extent [%u, %u]\n", start, end); */

    if (length<size) {
	printf("error in findFit: length (%u) is still < size (%u)\n",
	    length, size);
	exit(1);
    }

    if (end < start || end > maxAddress) {
	printf("error in findFit: start=%u, end=%u, maxAddress=%u\n",
	    start, end, maxAddress);
	exit(1);
    }
    
    if (length > size) {
	startTmp = start + (myRandom() % (length - size) );
    } else {
	/* length = size */
	startTmp = start;
    }

    /* now do alignment (if the size is aligned) */
    if (!(size%alignQuanta) || prob(alignProb)) {
	/* size is aligned */
	startAlign = (unsigned int)
		    round((double)startTmp / alignQuanta) * alignQuanta;
	if (startAlign < maxAddress && startAlign < maxAddress - size) {
	    /* alignment generates an ok address */
#ifdef DEBUG
	    printf("aligning this request to %u\n", alignQuanta);
#endif
	    startTmp = startAlign;
	} else {
#ifdef DEBUG
	    printf("can't align: out of bounds, startTmp %lf, size %lf\n",
		startTmp, size);
#endif
	}
    } else {
#ifdef DEBUG
	printf("leaving un-aligned (size not aligned)\n");
#endif
    }
    return(startTmp);
}

unsigned int getLocRandom(reUseTarget, hitDepthBytes, size, fileSize, uniqueBytes, file, alignQuanta, alignProb, numHitAttemptPtr, numMissAttemptPtr)
    double reUseTarget;
    double hitDepthBytes;
    unsigned int size;
    unsigned int fileSize;
    unsigned int uniqueBytes;
    int file;
    unsigned int alignQuanta;
    double alignProb;
    int *numHitAttemptPtr;
    int *numMissAttemptPtr;
{
    int hitFlag;
    unsigned int start;

    unsigned int getMiss();
    unsigned int getHit();
    double round();
    int prob();

    /* is this a hit or miss? */
    /* miss ratio is 1/reUseTarget */
    hitFlag = !prob(1.0/reUseTarget);
    if (hitFlag) {
	/* hit */
#ifdef DEBUG
	printf("hit\n");
#endif
	start = getHit(&hitFlag, hitDepthBytes, size, fileSize, uniqueBytes,
			file, alignQuanta, alignProb);
	if (hitFlag) {
#ifdef DEBUG
	    printf("trying to hit at [%u, %u]\n", start, start+size-1);
#endif
	    (*numHitAttemptPtr)++;
	} else {
#ifdef DEBUG
	    printf("originally chose hit, but couldn't get a good hit\n");
#endif
	}
    }
    if (!hitFlag) {
	/* miss */
#ifdef DEBUG
	printf("miss\n");
#endif
	start = getMiss(size, fileSize, file, alignQuanta, alignProb);
#ifdef DEBUG
	printf("trying to miss at [%u, %u]\n", start, start+size-1);
#endif
	(*numMissAttemptPtr)++;
    }

    /* align start to MINSIZE */
    start = round((double)start / MINSIZE) * MINSIZE;

    /*
    if (start < MINSIZE) {
	start = MINSIZE;
    }
    */

    if (start >= fileSize) {
	printf("error: starting address %u >= than fileSize (%u)\n",
	    start, fileSize);
	exit(1);
    }

    if (start+size > fileSize) {
	printf("error: ending address %u > than fileSize (%u)\n",
	    start+size, fileSize);
	exit(1);
    }

    if (start+size < start) {
	printf("error: start+size (%u) < start (%u)\n", start+size, start);
	exit(1);
    }

    return(start);
}
