#include <stdio.h>
#include <sys/types.h>
#include <string.h>
/* #include <strings.h> */
#include "option.h"
#include <sys/time.h>
#include "specWl.h"
#include <math.h>

#define copystring(x,y) { x = (char *) malloc((unsigned int) strlen(y)+1); strcpy(x,y);}

void getParamSpecWl(argc, argv, specPtr)
    int argc;
    char **argv;
    WLPARAM *specPtr;

{
    double uniqueBytesKB;
    double sizeMeanKB;
    double alignQuantaKB;
    Option optionArray[14];

    void optionInit();
    void *malloc();
    double round();

    optionInit(optionArray+0, OPT_STRING, "d", (char *) &(specPtr->dirName),
	"directory to access");
    optionInit(optionArray+1, OPT_FLOAT, "u", (char *) &uniqueBytesKB,
	"uniqueBytes--number of unique bytes transferred (KB, double)");
    optionInit(optionArray+2, OPT_FLOAT, "re", (char *) &(specPtr->reUse),
	"reuse--how many times each byte is used (double)");
    optionInit(optionArray+3, OPT_FLOAT, "h", (char *) &(specPtr->hitDepth),
	"hit distance--average LRU distance (fraction of uniqueBytes)");
    optionInit(optionArray+4, OPT_FLOAT, "r", (char *) &(specPtr->readProb),
	"fraction of reads (double)");
    optionInit(optionArray+5, OPT_FLOAT, "s", (char *) &sizeMeanKB,
	"mean request size (KB, double)");
    optionInit(optionArray+6, OPT_FLOAT, "sc", (char *) &(specPtr->sizeCVar),
	"size coefficient of variation (double)");
    optionInit(optionArray+7, OPT_INT, "p", (char *) &(specPtr->processNum),
	"number of processes (int)");
    optionInit(optionArray+8, OPT_FLOAT, "sh", (char *) &(specPtr->sharing),
	"how much sharing (double)");
    optionInit(optionArray+9, OPT_FLOAT, "c", (char *) &(specPtr->cpuThink),
	"cpu think time in between I/O (ms, double)");
    optionInit(optionArray+10, OPT_FLOAT, "ap", (char *) &(specPtr->alignProb),
	"fraction of aligned requests (double)");
    optionInit(optionArray+11, OPT_FLOAT, "a", (char *) &alignQuantaKB,
	"quanta of alignment (system blocksize) for most requests (KB, double)");
    optionInit(optionArray+12, OPT_FLOAT, "q", (char *) &(specPtr->seqProb),
	"fraction of sequential requests (double)");
    optionInit(optionArray+13, OPT_INT, "se", (char *) &(specPtr->seed),
	"random seed (int)");
    
    /* set up default values */
    copystring(specPtr->dirName,"./files");
    uniqueBytesKB=40.0; /* default is 40 KB */
    specPtr->reUse = 1.0;
    specPtr->hitDepth = .5;
    specPtr->readProb = .5;
    sizeMeanKB = 4.0;
    specPtr->sizeCVar = 1.0;
    specPtr->processNum = 1;
    specPtr->sharing = 0;
    specPtr->cpuThink = 0;
    specPtr->seqProb=0.0;
    alignQuantaKB=BUFSIZ/1024.0; /* default is BUFSIZ bytes */
    specPtr->alignProb = .9;
    specPtr->seed = 11;

    Opt_Parse(argc, argv, optionArray, Opt_Number(optionArray), 0);

    if (specPtr->reUse<1) {
	printf("error: reUse=%lf, must be at least 1\n", specPtr->reUse);
	exit(1);
    }

    if (specPtr->hitDepth>1) {
	printf("error: hitDepth=%lf, should be less than 1\n", specPtr->hitDepth);
	exit(1);
    }

    if (specPtr->sharing<0) {
	printf("error: sharing=%lf\n", specPtr->sharing);
	exit(1);
    }

    if (sizeMeanKB <= 0) {
	printf("error: sizeMeanKB = %lf\n", sizeMeanKB);
	exit(1);
    }

    if (uniqueBytesKB <= 0) {
	printf("error: uniqueBytesKB = %lf\n", uniqueBytesKB);
	exit(1);
    }

    if (alignQuantaKB <= 0) {
	printf("error: alignQuantaKB = %lf\n", alignQuantaKB);
	exit(1);
    }

    if (specPtr->processNum <= 0) {
	printf("error: specPtr->processNum = %d\n", specPtr->processNum);
	exit(1);
    }

    specPtr->sizeMean = (unsigned int) round(sizeMeanKB*1024.0);
    specPtr->uniqueBytes = (unsigned int) round(uniqueBytesKB*1024.0);

    /* align uniqueBytes to MINSIZE*processNum */

    specPtr->uniqueBytes = (int)(round(specPtr->uniqueBytes/(MINSIZE*specPtr->processNum)) * MINSIZE*specPtr->processNum);
    if (specPtr->uniqueBytes <= 0) {
	specPtr->uniqueBytes = (int) (MINSIZE*specPtr->processNum);
    }

    specPtr->alignQuanta = (unsigned int) round(alignQuantaKB*1024.0);
}
