#include <stdio.h>
#include <math.h>

#define NUMCHOPTRIES 1000
#define MILLION 1000000

int prob(a)
    double a;
{
    /* decide whether this random event happens (event happens with probability
	a) */
    long myRandom();

    int b;
    b = 1000;
    return ( (myRandom()%b) < a*b );
}

double expon(mean)
   double mean;
{
   double u;
   long myRandom();
   /* round UP */
   do {u=(myRandom()%1000000)/1000000.0;} while (u<=0.0);
   return(ceil(-1*mean*log(u)));
}

double normal(mean,stdev)
   double mean;
   double stdev;
{
   double u;
   double v1,v2;
   long myRandom();
   do {
      do {u=(myRandom()%1000000)/1000000.0;} while (u<=0.0);
      v1= -1*log(u);
      do {u=(myRandom()%1000000)/1000000.0;} while (u<=0.0);
      v2= -1*log(u);
   } while (v2<(v1-1)*(v1-1)/2);
   if (myRandom()%2) return((-1*stdev*v1)+mean);
   else return(stdev*v1+mean);

   /*
   v1=ceil(v1*stdev);
   if (myRandom()%2) return((int)((-1*v1)+mean));
   else return((int)(v1+mean));
   */
}

double hnormal(stdev)
   double stdev;
{
   double normal();
   return(fabs(normal(0.0,stdev)));
}

double normalChop(mean, stdev, min, max)
    double mean;
    double stdev;
    double min;
    double max;
{
    /* return a number from a normal distribution, but with the result
	constrained to be [min, max] */
    
    double result;
    int i;

    double normal();

    stdev = max;

    printf("called normalChop with min %lf, mean %lf, max %lf\n", min, mean, max);

    if (mean < min || max < mean) {
	printf("error in normalChop: min (%lf), mean (%lf), max (%lf) ordered wrong\n",
	    min, mean, max);
	exit(1);
    }

    /* first find out which is more constraining (closer to the mean) */
    if ( max-mean > mean-min ) {
	max = mean + mean - min;
    } else {
	min = mean - (max - mean);
    }

    printf("now min %lf, mean %lf, max %lf\n", min, mean, max);
    i=0;
    do {
	result = normal(mean, stdev);
	printf("result=%lf\n", result);
	i++;
    } while ( (result < min || result > max) && i<NUMCHOPTRIES);

    if (i>=NUMCHOPTRIES) {
	printf("error: normalChop tried too many times, min=%lf, mean=%lf, max=%lf\n", min, mean, max);
	exit(1);
    }
    printf("i=%d\n", i);
    printf("*result=%lf\n", result);
    return(result);
}

/* bernoulli distribution */
/* implements a bernoulli distribution by throwing n balls with p
    probability */

/* also makes the result continuous by varying the result by +- C/2 */

double bern(mean, stDev, min, max /*, skew */)
    double mean;
    double stDev;
    double min;
    double max;
    /* int skew; how wide to split the original distribution into two
		distributions */
{
    double variance;
    double p, n, C;
    int i;
    double result;
    double fraction;

    long myRandom();

    /*
    printf("mean = %lf, stDev = %lf, min = %lf, max = %lf\n", mean, stDev,
	min, max);
    */

    variance = stDev * stDev;

    if (mean >= max) {
	return(max);
    }

    if (stDev == 0) {
	return(mean);
    }

    C = max * variance / (max * mean - mean*mean);
    /*
    */
    if (C>max) {
	C = max;
    }
    n = mean * mean / (C * mean  - variance );
    if (n>MILLION) {
	printf("warning in bern: n=%lf too large\n", n);
	printf("mean = %lf, stDev = %lf, max = %lf\n", mean, stDev, max);
	printf("setting bern result = mean = %lf\n", mean);
	return(mean);
	/* exit(1); */
    }
    /* p = 1 - variance / (C * mean); */
    p = mean / (C * n);

    /*
    printf("C = %lf, n = %lf, p = %lf\n", C, n, p);
    */

    result=0;

    /*
    printf("bern called with p=%lf, n=%lf, C=%lf, max=%lf\n", p, n, C, max);
    */

    if (p<0 || n<0 || C<0) {
	printf("error in bern: p=%lf, n=%lf, C=%lf\n", p, n, C);
	exit(1);
    }

    for (i=1; i<=n; i++) {
	if ( (myRandom()%MILLION)/(double)MILLION < p) {
	    result++;
	}
    }

    /* now take care of the fractional part of n */
    fraction = n - floor(n);
    /*
    printf("fraction of %lf is %lf\n", n, fraction);
    */
    if ( ((myRandom()%MILLION)/(double)MILLION) < p ) {
	result+=fraction;
    }

    result *= C;

    /* vary the result by +- C/2 to make the result continuous */
    result = result - C/2.0 + C * ((myRandom()%MILLION)/(double)MILLION);

    /* printf("result=%d\n", result); */

    if (result > max) {
	/*
	printf("bern: --M--\n");
	*/
	return(max);
    }
    if (result < 0) {
#ifdef DEBUG
	printf("bern: --0--\n");
#endif
	return(min);
    }
    return(result);
}
