#include <stdio.h>
#include <math.h>
#include "specWl.h"

#define MAXSIZETRIES 100
#define MAX(a,b) ( ( (a) > (b) ) ? (a) : (b)  )
#define MIN(a,b) ( ( (a) < (b) ) ? (a) : (b)  )

unsigned int getSize(sizeMean, sizeCVar, maxSize, alignQuanta, alignProb,
		    sizeAtMin)
    unsigned int sizeMean;
    double sizeCVar;
    unsigned int maxSize;
    unsigned int alignQuanta;
    double alignProb;
    int sizeAtMin;
{
    double size;
    int i;

    double expon();
    double normal();
    double bern();
    double round();
    int prob();

#ifdef DEBUG
    printf("maxSize = %lf KB\n", maxSize/1024.0);
#endif

    /* decide which size type to use */
    i=0;
    do {
	/*
	size=expon((double)sizeMean);
	size=normal((double)sizeMean, sizeMean*sizeCVar);
	*/
	size = (unsigned int) bern((double)sizeMean, sizeMean*sizeCVar, MINSIZE,
		    MIN((double) maxSize,
			(double) sizeMean * MAX(sizeCVar*sizeCVar+1, 10.0)));
	    /* this limit on the maxSize is to limit bern from taking too
		long (n grows very large in bern with large maxSize) */

#ifdef DEBUG
	printf("%d: size=%lf\n", i, size);
#endif
	i++;
	if (!sizeAtMin && i<MAXSIZETRIES/2) {
	    /* only align if you haven't tried too many sizes already */
	    if (prob(alignProb)) {
		if (size <= alignQuanta) {
		    size = alignQuanta;
		} else {
		    size = round((double)size / alignQuanta) * alignQuanta;
		}
	    }
	}
	
	/* always align to MINSIZE */
	size = round((double)size / MINSIZE) * MINSIZE;
	if (size < MINSIZE) {
	    size = MINSIZE;
	}
    } while ( i<MAXSIZETRIES && (size<=0 || size > maxSize));
    if (i>=MAXSIZETRIES) {
	printf("error in getSize: too many iterations, sizeMean=%u, sizeCVar=%lf, maxSize=%u\n", sizeMean, sizeCVar, maxSize);
	exit(1);
    }
    return((unsigned int) size);
}
