#include <stdio.h>

#define MYBUFSIZ 4096 /* also the default alignment */
#define FILENAMEMAX 200
#define MAXIOCOMMANDLEN 80
#define PROCMAX 50 /* max number of processes */
#define FILENUMMAX 20 /* ??? a system defined limit */
#define MAXITER 10000000 /* max number of iterations to be done by a child */
#define MINSIZE 512.0 /* minimum size is 512 bytes */
#define FEEDBACKINTERVAL 1 /* how many iterations between modifying target
				for hitDepth */
#define OVERSHOOT 1.2 /* fudge factor to get the feedback mechanism to
			overshoot a bit */
#define CAPACITYEXPANSION 1.0

#define UPDATEWORKLOAD 100 /* how frequently to update the workload you're
				shooting for */

#define CHILDFILE "child"
#define PARENTFILE "parent"

typedef struct {
    char name[FILENAMEMAX];
    char buffer[MYBUFSIZ];
    int current; /* how many bytes are in the buffer so far */
} CHILDCMDFILE;

typedef struct {
    char *dirName; /* what directory the test files go in */
    unsigned int uniqueBytes; /* total number of unique bytes touched in this
                                    run */
    double reUse; /* how many times each byte gets accessed */
    double hitDepth; /* average LRU depth (fraction of uniqueBytes) */
    double readProb; /* fraction of reads */
    unsigned int sizeMean; /* average request size in bytes */
    double sizeCVar; /* coefficient of variation of request size */
    int processNum; /* how many processes */
    double sharing; /* how much sharing there is */
    double cpuThink; /* cpu think time between I/O's (ms) */
    double seqProb; /* probability of sequentiality */
    unsigned int alignQuanta; /* quanta of alignment for most requests */
    double alignProb; /* probability that a request is aligned */
    int seed; /* random seed */
} WLPARAM;

#define NOPARAMETER 0
#define ALLPARAMETER 0xffffffff
#define UNIQUEBYTES 1
#define REUSE 2
#define HITDEPTH 4
#define READPROB 8
#define SIZEMEAN 16
#define SIZECVAR 32
#define PROCESSNUM 64
#define SHARING 128
#define CPUTHINK 256
#define SEQPROB 512
#define ALIGNQUANTA 1024
#define ALIGNPROB 2048
#define MAXWLPARAM ALIGNPROB
#define MAXPARAMINDEX 15 /* this should be >= the lg of MAXWLPARAM */

#define POSITIVE_PARAM (REUSE | SIZEMEAN | PROCESSNUM | SEQPROB | ALIGNQUANTA | ALIGNPROB)
#define NEGATIVE_PARAM (UNIQUEBYTES | HITDEPTH | CPUTHINK | SIZECVAR)
/* these parameters don't fall in either category:
    READPROB | SHARING, or are
    not currently being varied */

#define PROB_PARAM (HITDEPTH | READPROB | SHARING | SEQPROB | ALIGNPROB)
