#include <stdio.h>
#include <math.h>
#include <string.h>
#include "specWl.h"

getSpecWlResultFile(specPtr, filePtr)
    WLPARAM *specPtr;
    FILE *filePtr;
{
    /* take an open file stream pointer and read the result from a
	specWl run */

    double paramValue;
    int whichParam;
    char tmpStr[200];
    char tmpStr1[200];
    int status;
    char *location;

    char *convertParamStr();
    double convertParamVal();

    for (whichParam=1; whichParam<=MAXWLPARAM; whichParam*=2) {
	sprintf(tmpStr, "%s value is %%lf\n", convertParamStr(whichParam));
	fgets(tmpStr1, 199, filePtr);
	status = sscanf(tmpStr1, tmpStr, &paramValue);
	if (status == 0 && (whichParam == SEQPROB ||
	    whichParam == READPROB || whichParam == ALIGNPROB) ) {
	    /*
	    printf("wasn't able to read anything in for %s, trying with Prob instead of Frac\n", convertParamStr(whichParam));
	    */
	    location = strstr(tmpStr, "Frac");
	    if (location != NULL) {
		/* substitute in Prob for Frac */
		location[0] = 'P';
		location[1] = 'r';
		location[2] = 'o';
		location[3] = 'b';
		/* printf("new tmpStr = %s\n", tmpStr); */
		status = sscanf(tmpStr1, tmpStr, &paramValue);
	    }
	}
	if (status != 1) {
	    printf("error in getSpecWlResultFile: only %d items read\n",
		status);
	    exit(1);
	}
	assignParamVal(specPtr, whichParam, paramValue);
	/*
	printf("read value for %s as %lf\n", convertParamStr(whichParam),
	    convertParamVal(specPtr, whichParam));
	*/
    }
}

getSpecWlResult(param, dirName)
    WLPARAM *param;
    char *dirName;
{
    char tmpFileName[100];
    FILE *tmpFilePtr;
    int status;

    sprintf(tmpFileName, "%s/specWl.adaptWl", dirName);
    tmpFilePtr = fopen(tmpFileName, "r");
    if (tmpFilePtr == NULL) {
	perror("error in getSpecWlResult: fopen");
	exit(1);
    }
    status = fscanf(tmpFilePtr,"uniqueBytes %u\n", &(param->uniqueBytes));
    if (status != 1) {
	printf("error in getSpecWlResult0: only read %d items\n", status);
	exit(1);
    }
    status = fscanf(tmpFilePtr,"reUse %lf\n", &(param->reUse));
    if (status != 1) {
	printf("error in getSpecWlResult1: only read %d items\n", status);
	exit(1);
    }
    status = fscanf(tmpFilePtr,"hitDepth %lf\n", &(param->hitDepth));
    if (status != 1) {
	printf("error in getSpecWlResult2: only read %d items\n", status);
	exit(1);
    }
    status = fscanf(tmpFilePtr,"readFrac %lf\n", &(param->readProb));
    if (status != 1) {
	printf("error in getSpecWlResult3: only read %d items\n", status);
	exit(1);
    }
    status = fscanf(tmpFilePtr,"sizeMean %u\n", &(param->sizeMean));
    if (status != 1) {
	printf("error in getSpecWlResult4: only read %d items\n", status);
	exit(1);
    }
    status = fscanf(tmpFilePtr,"sizeCVar %lf\n", &(param->sizeCVar));
    if (status != 1) {
	printf("error in getSpecWlResult5: only read %d items\n", status);
	exit(1);
    }
    status = fscanf(tmpFilePtr,"processNum %d\n", &(param->processNum));
    if (status != 1) {
	printf("error in getSpecWlResult6: only read %d items\n", status);
	exit(1);
    }
    status = fscanf(tmpFilePtr,"sharing %lf\n", &(param->sharing));
    if (status != 1) {
	printf("error in getSpecWlResult7: only read %d items\n", status);
	exit(1);
    }
    status = fscanf(tmpFilePtr,"cpuThink %lf\n", &(param->cpuThink));
    if (status != 1) {
	printf("error in getSpecWlResult8: only read %d items\n", status);
	exit(1);
    }
    status = fscanf(tmpFilePtr,"seqFrac %lf\n", &(param->seqProb));
    if (status != 1) {
	printf("error in getSpecWlResult9: only read %d items\n", status);
	exit(1);
    }
    status = fscanf(tmpFilePtr,"alignQuanta %u\n", &(param->alignQuanta));
    if (status != 1) {
	printf("error in getSpecWlResult10: only read %d items\n", status);
	exit(1);
    }
    status = fscanf(tmpFilePtr,"alignFrac %lf\n", &(param->alignProb));
    if (status != 1) {
	printf("error in getSpecWlResult11: only read %d items\n", status);
	exit(1);
    }

    fclose(tmpFilePtr);
}

printWlParam(specPtr)
    WLPARAM *specPtr;
{
    printWlParamFile(specPtr, stdout);
    /*
    int whichParam;

    char *convertParamStr();
    double convertParamVal();

    for (whichParam=1; whichParam<=MAXWLPARAM; whichParam*=2) {
	printf("%s value is %lf\n", convertParamStr(whichParam),
	    convertParamVal(specPtr, whichParam));
    }
    printf("\n");
    */
}

printWlParamFile(specPtr, filePtr)
    WLPARAM *specPtr;
    FILE *filePtr;
{
    int whichParam;

    char *convertParamStr();
    double convertParamVal();

    for (whichParam=1; whichParam<=MAXWLPARAM; whichParam*=2) {
	fprintf(filePtr, "%s value is %lf\n", convertParamStr(whichParam),
	    convertParamVal(specPtr, whichParam));
    }
    fprintf(filePtr, "\n");
}
