#define MAX(a,b) ( ( (a) > (b) ) ? (a) : (b)  )
#define MIN(a,b) ( ( (a) < (b) ) ? (a) : (b)  )

typedef struct TWOTHREENODELRU {
    /* if this is a branch node */
    struct TWOTHREENODELRU *left;
    struct TWOTHREENODELRU *middle;
    struct TWOTHREENODELRU *right;
    unsigned int bytesLeft; /* number of bytes in left subtree */
    unsigned int bytesMiddle; /* number of bytes in middle subtree */
    unsigned int bytesRight; /* number of bytes in right subtree */

    /* if this is a leaf (left == NULL) */
    unsigned int start; /* starting address for this extent */
    unsigned int end; /* ending address */
    int file; /* which file this belongs to */
    struct TWOTHREENODE *addressPtr; /* points to the address node corresponding
					to this lru entry */

    /* for either leaf or node */
    struct TWOTHREENODELRU *parent; /* points to the parent of this node.
				    If this is the root node, parent = NULL */
    int id;

} TWOTHREENODELRU;

typedef struct TWOTHREENODE {
    /* if this is a branch node */
    struct TWOTHREENODE *left;
    struct TWOTHREENODE *middle;
    struct TWOTHREENODE *right;
    unsigned int minMiddle; /* minimum starting address in tree under middle
				node */
    unsigned int minRight; /* minimum starting address in tree under right
				node */

    /* if this is a leaf (left == NULL) */
    unsigned int start; /* starting address for this extent */
    unsigned int end; /* ending address */
    TWOTHREENODELRU *lruPtr; /* points to an lru leaf */

    /* for either leaf or node */
    struct TWOTHREENODE *parent; /* points to the parent of this node.  If this
				    is the root node, parent = NULL */
    int id;

} TWOTHREENODE;
