/* This is a test for Sun Solaris asynchronous I/O interface()
 * A file is open, data of it is read into memory,
 * some operation is done on it, finally the modified data is written 
 * to its original position.
 * We uses three buffers, one for read, one for write, and one for
 * operation. Currently the operation is qsort it. 
 * 
 * test source files are:
 * asyn_io.test.c  for asynchronous read/write
 * syn_io.test.c   for synchronous read/write
 *
 * Created by Junfeng Zhang
 */  

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/mman.h>
#include <sys/times.h>
#include <sys/stat.h>
#include <sys/fcntl.h>
#include <unistd.h>
#include <sys/asynch.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <stdio.h>
#include <errno.h>

#define BUFFERSIZE 2048 
#define RECORD_SIZE 16

static void     pr_times(FILE *, clock_t, struct tms *, struct tms *);
static void     error(char *err_msg);
int myCmp(const void* t1, const void* t2);

int main(int argc, char *argv[])
{
  int fdin;
  int fout;
  FILE *fres;
  struct stat statbuf;
  struct tms tmsstart, tmsend;
  clock_t start, end;
  char buf[3][BUFFERSIZE];
  int n;
  char *map_src;
  int read_pos;
  int write_pos;
  aio_result_t read_stat;
  aio_result_t *read_result;
  aio_result_t write_stat;
  aio_result_t *write_result;
  int count;
  int read_done = 0;
  int write_done = 0;
  int i;


  if (argc != 3)
    error("Usage: asynio <testfile> <resultfile>\n");

  /* open the test file */
  if ((fdin = open(argv[1], O_RDWR))<0)
    error("can't open testfile \n");

  /* open result file */
  if (!(fres = fopen(argv[2],"a")))
    error("cannot open result file\n");

  if (fstat(fdin, &statbuf) < 0)
    error("fstat error\n");

  // asynchronous read/write 
  fprintf(fres, "\ntest of asynchronous read/write on file %s. \n", argv[1]);
  fprintf(fres, "filesize: %i bytes.\n\n", statbuf.st_size);

  if ( (start = times(&tmsstart)) == -1)         //starting values 
    error("times error\n");

  n = 1;
  read_pos = 0;
  write_pos = 0;
  if ((count = read(fdin, buf[1], BUFFERSIZE))<0) error("read() error\n");
  
  read_stat.aio_return = count;
  read_result = &read_stat;
  write_stat.aio_return = 0;
  write_result = &write_stat;
  write_done = 1;
  read_done = 1;

  do 
  {
    // read to buf[2], write from buf[0], sort buf[1]
    if (!read_done)
    {
      read_result = aiowait(NULL);
      if (read_result == &write_stat)
      {
        //fprintf(stderr, "write completed before read \n");
        write_result = read_result;
        write_done = 1;
        read_result = aiowait(NULL);
      }	
    }
    count = read_result->aio_return;
    read_pos += count;
    if (read_pos < statbuf.st_size)
    {
      //fprintf(stderr,"aioreading ...\n");
      //fprintf(stderr,"read_pos = %i \n", read_pos);
      if (aioread(fdin, buf[(n+1)%3], BUFFERSIZE, read_pos, 0, &read_stat)<0)
      {
        fprintf(stderr,"read_pos = %i, errno = %i\n", read_pos, errno);
        perror("line 107 aioread:");
        error("aioread error\n");
      }
      read_done = 0;
      //fprintf(stderr,"qsorting...\n");
      //fprintf(stderr,"sort_pos = %i \n", read_pos-count);
      //fprintf(stderr,"sort_length = %i\n", count/RECORD_SIZE*RECORD_SIZE);
      qsort(buf[n%3],count/RECORD_SIZE*RECORD_SIZE,RECORD_SIZE,myCmp);
      for(i=0;i<count;i++)
      {
       buf[n%3][i] += 1; 
      }    

      if (!write_done)
      {
        write_result = aiowait(NULL);
        if (write_result = &read_stat) 
        {
          //fprintf(stderr, "read completed before write\n");
          read_result = write_result;
          read_done = 1;
          write_result = aiowait(NULL);
        }
      }
      //write_pos += write_result->aio_return;
      write_pos = read_pos-count;
      //fprintf(stderr,"aiowriting...\n");
      //fprintf(stderr,"write_pos = %i \n", write_pos);
      if (aiowrite(fdin,buf[n%3],BUFFERSIZE,write_pos,0,&write_stat)<0)
      {
        fprintf(stderr,"write_pos = %i, errno = %i\n", write_pos, errno);
        perror("line 85 aiowrite:");
        error("aiowrite error\n");
      }
      write_done = 0;
      n++;
    }
  }
  while(read_pos<statbuf.st_size);

  aiowait(NULL);
  
  if ( (end = times(&tmsend)) == -1)            // ending values 
    error("times error\n");

  pr_times(fres, end-start, &tmsstart, &tmsend);
  
  if (close(fdin)==-1)
    error("close file error\n");

  if (fclose(fres)==-1)
    error("close file error\n");

  return 0;
}

void error(char *err_msg)
{
 fprintf(stderr, err_msg);
 exit(1);
}

static void
pr_times(FILE *fres, clock_t real, struct tms *tmsstart, struct tms *tmsend)
{
        static long             clktck = 0;

        if (clktck == 0)
        {/* fetch clock ticks per second first time */
          if ( (clktck = sysconf(_SC_CLK_TCK)) < 0)
            error("sysconf error");
          fprintf(fres, "clktlk = %i \n", clktck);
        }
        fprintf(fres, "  real:  %i clktck \n", real);
        fprintf(fres, "  user:  %i clktck\n",
                (tmsend->tms_utime - tmsstart->tms_utime));
        fprintf(fres, "  sys:   %i clktck\n",
                (tmsend->tms_stime - tmsstart->tms_stime));
        fprintf(fres, "  child user:  %i clktck\n",
                (tmsend->tms_cutime - tmsstart->tms_cutime));
        fprintf(fres, "  child sys:   %i clktck\n",
                (tmsend->tms_cstime - tmsstart->tms_cstime));
}

int myCmp(const void *t1, const void *t2)
{
  int x1=0;
  int x2=0;
  int i;
  for(i = 0; i<RECORD_SIZE; i++)
  {
    x1 += (int)((int *)t1+i);
    x2 += (int)((int *)t2+i);
  }
  return x1-x2;
} 
