#include <sys/types.h>
#include <sys/stat.h>
#include <sys/mman.h>
#include <sys/times.h>
#include <sys/stat.h>
#include <sys/fcntl.h>
#include <unistd.h>
#include <sys/asynch.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <stdio.h>

#define BUFFERSIZE 2048 
#define RECORD_SIZE 16

static void     pr_times(FILE *, clock_t, struct tms *, struct tms *);
static void     error(char *err_msg);
int myCmp(const void* t1, const void* t2);

int main(int argc, char *argv[])
{
  int fdin;
  FILE *fres;
  struct stat statbuf;
  struct tms tmsstart, tmsend;
  clock_t start, end;
  char buf[BUFFERSIZE];
  int n;
  char *map_src;
  int pos;
  aio_result_t read_result;
  aio_result_t write_result;
  int count;
  int i;


  if (argc != 3)
    error("Usage: synio <testfile> <resultfile>\n");

  /* open the test file */
  if ((fdin = open(argv[1], O_RDWR))<0)
    error("can't open testfile \n");

  /* open result file */
  if (!(fres = fopen(argv[2],"a")))
    error("cannot open result file\n");

  if (fstat(fdin, &statbuf) < 0)
    error("fstat error\n");

  // synchronous read/write 
  fprintf(fres, "\ntest of synchronous read/write on file %s. \n", argv[1]);
  fprintf(fres, "filesize: %i bytes.\n\n", statbuf.st_size);

  if ( (start = times(&tmsstart)) == -1)        /* starting values */
    error("times error\n");

  n = 0;
  pos = 0;
  while((n=read(fdin, buf, BUFFERSIZE))>0)
  {
    // printf("qsorting.....\n");
    qsort(buf, n, RECORD_SIZE, myCmp);
  }

  if ( (end = times(&tmsend)) == -1)            /* ending values */
    error("times error\n");

  pr_times(fres, end-start, &tmsstart, &tmsend);

  if (close(fdin)==-1)
    error("close file error\n");

  if (fclose(fres)==-1)
    error("close file error\n");

  return 0;
}

void error(char *err_msg)
{
 fprintf(stderr, err_msg);
 exit(1);
}

static void
pr_times(FILE *fres, clock_t real, struct tms *tmsstart, struct tms *tmsend)
{
        static long             clktck = 0;

        if (clktck == 0)
        {/* fetch clock ticks per second first time */
          if ( (clktck = sysconf(_SC_CLK_TCK)) < 0)
            error("sysconf error");
          fprintf(fres, "clktlk = %i \n", clktck);
        }
        fprintf(fres, "  real:  %i clktck \n", real);
        fprintf(fres, "  user:  %i clktck\n",
                (tmsend->tms_utime - tmsstart->tms_utime));
        fprintf(fres, "  sys:   %i clktck\n",
                (tmsend->tms_stime - tmsstart->tms_stime));
        fprintf(fres, "  child user:  %i clktck\n",
                (tmsend->tms_cutime - tmsstart->tms_cutime));
        fprintf(fres, "  child sys:   %i clktck\n",
                (tmsend->tms_cstime - tmsstart->tms_cstime));
}

int myCmp(const void *t1, const void *t2)
{
  int x1=0;
  int x2=0;
  int i;
  for(i = 0; i<RECORD_SIZE; i++)
  {
    x1 += (int)((int *)t1+i);
    x2 += (int)((int *)t2+i);
  }
  return x1-x2;
} 
