#include <sys/types.h>
#include <sys/stat.h>
#include <sys/mman.h>
#include <sys/times.h>
#include <sys/stat.h>
#include <sys/fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <stdio.h>

#define BUFFERSIZE 1024

static void	pr_times(FILE *, clock_t, struct tms *, struct tms *);
static void     error(char *err_msg);

/* for read/write, try sequential/random  read/write */
/* try mmap(), read/write, directio */

int main(int argc, char *argv[])
{
  int fdin;
  FILE *fres;
  struct stat statbuf;
  struct tms tmsstart, tmsend;
  clock_t start, end;
  char buf[BUFFERSIZE];
  int n;
  char *map_src;
  int pos;
  
  if (argc != 3)
    error("Usage: seqwrite <testfile> <resultfile>\n");
  
  /* open the test file */  
  if ((fdin = open(argv[1], O_RDWR))<0)
    error("can't open testfile \n");
   
  /* open result file */
  if (!(fres = fopen(argv[2],"a")))
    error("cannot open result file\n");
  
  if (fstat(fdin, &statbuf) < 0)
    error("fstat error\n");

  // sequential write 
  fprintf(fres, "\ntest of sequential write on file %s. \n", argv[1]);
  fprintf(fres, "filesize: %i bytes.\n\n", statbuf.st_size);

  // standard read
  fprintf(fres, "Standard write:\n");
  if ( (start = times(&tmsstart)) == -1)	
    error("times error\n");

  // initialize buf
  for(n = 0; n < BUFFERSIZE; n++)
    buf[n] = n;

  n = 0;
  while((n += write(fdin, buf, BUFFERSIZE)) < statbuf.st_size);

  if ( (end = times(&tmsend)) == -1)	
    error("times error\n");

  pr_times(fres, end-start, &tmsstart, &tmsend);

/*
  // directio read
  fprintf(fres, "directio Read:\n");

  if (directio(fdin, DIRECTIO_ON) == -1)
  { 
    perror("what is wrong?"); 
    error("directio error\n");
  }
  if (lseek(fdin, 0, SEEK_SET) == -1 )
    error("lseek error\n");

  if ( (start = times(&tmsstart)) == -1)	// starting values 
    error("times error\n");

  while((n += write(fdin, buf, BUFFERSIZE))<statbuf.st_stize);

  // make sure the modification are on disk
  if (fsync(fdin)== -1) 
    error("fsync error\n");


  if ( (end = times(&tmsend)) == -1)		// ending values 
    error("times error\n");

  pr_times(fres, end-start, &tmsstart, &tmsend);
*/

/*
  if (lseek(fdin, 0, SEEK_SET) == -1 )
    error("lseek error\n");

  // mmap read
  fprintf(fres, "\nmmap() write:\n");

  if ( (start = times(&tmsstart)) == -1)	 //starting values
    error("times error\n");

  if ( (map_src = mmap(0, statbuf.st_size, PROT_WRITE,
				   MAP_SHARED, fdin, 0)) == (caddr_t) -1)
  {
    perror("what is wrong:");
    error("mmap error for input\n");
  }

  pos = 0;
  while(pos <statbuf.st_size)
  {
    if ((pos + BUFFERSIZE)>=statbuf.st_size)
    {
      memcpy(map_src+pos, buf, statbuf.st_size - pos);
    }
    else
    {
      memcpy(map_src+pos, buf, BUFFERSIZE);
    }
    pos += BUFFERSIZE;
  }

  if ( (end = times(&tmsend)) == -1)		//ending values
    error("times error\n");

  pr_times(fres, end-start, &tmsstart, &tmsend);
*/
  if (close(fdin)==-1)
    error("close file error\n");

  if (fclose(fres)==-1)
    error("close file error\n");

  return 0;
}
    

void error(char *err_msg)
{
 fprintf(stderr, err_msg);
 exit(1);
}

static void
pr_times(FILE *fres, clock_t real, struct tms *tmsstart, struct tms *tmsend)
{
	static long		clktck = 0;

	if (clktck == 0)
        {/* fetch clock ticks per second first time */
          if ( (clktck = sysconf(_SC_CLK_TCK)) < 0)
            error("sysconf error");
          fprintf(fres, "clktlk = %i \n", clktck);
        }
	fprintf(fres, "  real:  %i clktck \n", real);
	fprintf(fres, "  user:  %i clktck\n",
	        (tmsend->tms_utime - tmsstart->tms_utime));
	fprintf(fres, "  sys:   %i clktck\n",
	        (tmsend->tms_stime - tmsstart->tms_stime));
	fprintf(fres, "  child user:  %i clktck\n",
	        (tmsend->tms_cutime - tmsstart->tms_cutime));
	fprintf(fres, "  child sys:   %i clktck\n",
	        (tmsend->tms_cstime - tmsstart->tms_cstime));
}
