/* This is a test for multithread throughput
 * We open a file, do some operation on each block of it,
 * and write it back. mmap interface is used for read/write,
 * which is the fastest in all I/O interfaces,
 * and it is the most easiest way to do I/O for multithreads
 *
 * Created by Junfeng Zhang for CS736 Fall 2000 project
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/mman.h>
#include <sys/times.h>
#include <sys/stat.h>
#include <sys/fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <stdio.h>
#include <thread.h>
#include <pthread.h>

#define BUFFERSIZE 1024
#define RECORDSIZE 16
#define _REENTRANT

static void	pr_times(FILE *, clock_t, struct tms *, struct tms *);
static void     error(char *err_msg);
int myCmp(const void* t1, const void* t2);

struct thr_work{
   char *map_src;
   int begin;
   int length;
};

void *partial_work(void *); /* thread routine */
  
int main(int argc, char *argv[])
{
  int fdin;
  FILE *fres;
  struct stat statbuf;
  struct tms tmsstart, tmsend;
  clock_t start, end;
  char *map_src;
  int noOfThreads;
  thread_t *tid;
  thr_work *twork;
  
  if (argc != 4)
    error("Usage: pthr_test <number of thread> <testfile> <resultfile>\n");
  
  noOfThreads = atoi(argv[1]);
  tid = new thread_t[noOfThreads];
  twork = new thr_work[noOfThreads];

  /* open the test file */  
  if ((fdin = open(argv[2], O_RDWR))<0)
    error("can't open testfile");
   
  /* open result file */
  if (!(fres = fopen(argv[3],"a")))
    error("cannot open result file");
  
  if (fstat(fdin, &statbuf) < 0)
    error("fstat error");

  int seg_size = statbuf.st_size/(noOfThreads * BUFFERSIZE);
  seg_size *= BUFFERSIZE;

  // write the header of test result
  fprintf(fres, "\ntest of multithread on file %s. \n", argv[2]);
  fprintf(fres, "number of threads: %i\n", noOfThreads);
  fprintf(fres, "filesize: %i bytes.\n\n", statbuf.st_size);

  if ( (start = times(&tmsstart)) == -1)
    error("times error\n");

  if ( (map_src = mmap(0, statbuf.st_size, PROT_WRITE,
				   MAP_SHARED, fdin, 0)) == (caddr_t) -1)
    error("mmap error for input");

  // initialize data segments for threads
  for (int i=0;i<noOfThreads; i++)
  {
   twork[i].map_src = map_src;
   twork[i].begin = seg_size * i;
   twork[i].length = statbuf.st_size - twork[i].begin;
   if (twork[i]. length > seg_size)
     twork[i].length = seg_size;
  }

  // create threads
  for( int i=0; i<noOfThreads; i++)
  {
    pthread_create(&tid[i], NULL, partial_work, &twork[i]);
  }
  for(int i=0; i<noOfThreads; i++)
  {
    pthread_join(tid[i], NULL);
  }

  /* 
  // using solaris thread
  for (int i=0; i<noOfThreads; i++)
  {
    thr_create(NULL, 0, partial_work, &twork[i], 0, &tid[i]);
  }
  while(thr_join(NULL,NULL,NULL)==0);
  */
 
  if ( (end = times(&tmsend)) == -1)
    error("times error");

  pr_times(fres, end-start, &tmsstart, &tmsend);
  
  if (close(fdin)==-1)
    error("close file error");

  if (fclose(fres)==-1)
    error("close file error");

  return 0;
}

void *partial_work(void *arg)
{
  thr_work *twork = (thr_work *)arg;
  char *pos = twork->map_src + twork->begin;
  
  for(int i=0; i<twork->length/BUFFERSIZE; i++)
  {
    qsort(pos, BUFFERSIZE, RECORDSIZE, myCmp);
  }
  return(NULL);
}
      

void error(char *err_msg)
{
 fprintf(stderr, "%s\n", err_msg);
 exit(1);
}

static void
pr_times(FILE *fres, clock_t real, struct tms *tmsstart, struct tms *tmsend)
{
	static long		clktck = 0;

	if (clktck == 0)
        {/* fetch clock ticks per second first time */
          if ( (clktck = sysconf(_SC_CLK_TCK)) < 0)
            error("sysconf error");
          fprintf(fres, "clktlk = %i \n", clktck);
        }
	fprintf(fres, "  real:  %i clktck \n", real);
	fprintf(fres, "  user:  %i clktck\n",
	        (tmsend->tms_utime - tmsstart->tms_utime));
	fprintf(fres, "  sys:   %i clktck\n",
	        (tmsend->tms_stime - tmsstart->tms_stime));
	fprintf(fres, "  child user:  %i clktck\n",
	        (tmsend->tms_cutime - tmsstart->tms_cutime));
	fprintf(fres, "  child sys:   %i clktck\n",
	        (tmsend->tms_cstime - tmsstart->tms_cstime));
}

int myCmp(const void *t1, const void *t2)
{
  int x1=0;
  int x2=0;
  int i;
  for(i = 0; i<RECORDSIZE; i++)
  {
    x1 += (int)((int *)t1+i);
    x2 += (int)((int *)t2+i);
  }
  return x1-x2;
} 
