#include "ddg.h"
#include <stdlib.h>
#include <stdio.h>

static void panic(char *thestring){
  fprintf(stderr, "Error in ddg.c: %s\n", thestring);
  exit(-1);
}

struct ddg_ll *ddg_init(){
  struct ddg_ll *temp;
  struct _bucket *new_ddg_struct;
  int looper, looper2;

  temp = (struct ddg_ll *)calloc(DDG_HASH_SIZE, (sizeof(struct ddg_ll)));
  for (looper=0; looper < DDG_HASH_SIZE; looper++) {
    new_ddg_struct = (struct _bucket *)calloc(DDG_LL_ATOM_SIZE, 
						 (sizeof(struct _bucket)));
    temp[looper].ddgs[0]=new_ddg_struct;
    temp[looper].addr[0]=0;
    init_ddg_struct(new_ddg_struct); /*Change from critical_init*/
    for (looper2=1; looper2 < DDG_LL_ATOM_SIZE; looper2++){
      temp[looper].ddgs[looper2] = NULL;
      temp[looper].addr[looper2] = 0;
    }
    temp[looper].next = NULL;
  }
  return temp;
}

inline struct _bucket 
*ddg_get_addr_data(struct ddg_ll *list, int address){
  /*This function gets the bucket associated with an address*/
  /*It returns -1 if the bucket isn't found, meaning, this address doesn't have an entry.*/
  int temp;
  struct ddg_ll *looper;
  int looper2;

  temp = DDG_HASH_FUNCTION(address);
  for (looper = &list[temp]; looper != NULL; looper = looper->next){
    for (looper2=0; looper2 < DDG_LL_ATOM_SIZE; looper2++){
      if (!looper->ddgs[looper2])
	return (struct _bucket *)-1;
      if (looper->addr[looper2] == address)
	return looper->ddgs[looper2];
    }
  }
  return (struct _bucket*)-1;
}

/*This function initializes all values within a ddg struct*/
inline void init_ddg_struct(struct _bucket *ddgs){
  ddgs->count = 0;
  ddgs->write = 0;
  ddgs->event = NULL;
  ddgs->prev = NULL;
  ddgs->next = NULL;
}

/*This function copies a ddg struct from one to another (by value)*/
inline void copy_ddg_struct(struct _bucket *dest, struct _bucket *src){
  dest->count=src->count;
  dest->write=src->write;
  dest->event=src->event;
  dest->prev=src->prev;
  dest->next=src->next;
}

inline struct _bucket
*ddg_add_entry(struct ddg_ll *list, int address){
  /*This function adds an entry to the linked list passed for the address
    requested.*/

  int temp;
  int first_free_node;
  struct ddg_ll *last_atom;
  struct ddg_ll *looper;
  struct ddg_ll *temp_ddg_ll;
  int looper2;
  //struct ddg_ll *new_ddg_ll;
  struct _bucket *new_ddg_struct;
  /*kml do this so that malloc doesn't fragment our space too much*/

  temp = DDG_HASH_FUNCTION(address);
  for (looper = &list[temp]; looper; looper = looper->next) {
    for (looper2=0; looper2 < DDG_LL_ATOM_SIZE; looper2++){
      if (looper->ddgs[looper2]){
	if (looper->addr[looper2] == address)
	  return 0;  /*This entry is already in the table*/
      }
    }
  }

  /*Now loop through again and find the first free place to add a new node*/
  for (looper= &list[temp]; looper->next; looper=looper->next)
    {}
  for (looper2=0; looper2 < DDG_LL_ATOM_SIZE; looper2++){
    if (!looper->ddgs[looper2])
      break;  /*looper2 has the last free node #*/
  }
  first_free_node=looper2;
  last_atom=looper;

  if (!last_atom){
    fprintf(stderr, "No last atom\n");
    exit(-1);
  }

  /*Now see if the current ATOM is full or not, if so, add a new atom*/
  if (first_free_node==DDG_LL_ATOM_SIZE){
    /*Current atom is full, need another one*/
    temp_ddg_ll = (struct ddg_ll *)calloc(1, (sizeof(struct ddg_ll)));
    new_ddg_struct = (struct _bucket *)calloc(DDG_LL_ATOM_SIZE, 
						 (sizeof(struct _bucket))); 
    if ((!temp_ddg_ll) || (!new_ddg_struct)){
      fprintf(stderr, "Out of memory allocating storage for a new ddg data list item\n");
      fprintf(stderr, "Approx. Node count:  %d\n", count_nodes1(list));
      exit(-1);
    } 
    last_atom->next=temp_ddg_ll;
    for(looper2=0; looper2<DDG_LL_ATOM_SIZE; looper2++){
      temp_ddg_ll->addr[looper2]=0;
      temp_ddg_ll->ddgs[looper2]=NULL;
    }
    temp_ddg_ll->next=NULL;
    first_free_node=0;
    temp_ddg_ll->ddgs[0]=new_ddg_struct;
    last_atom=temp_ddg_ll;
  }

  /*Update new_ddg_struct to be the pointer to the right ddg struct*/
  new_ddg_struct=(last_atom->ddgs[0])+first_free_node;

  /*Now add the new ddg struct onto it*/
  //printf("LA->ddgs:  %p, LA->ddgs[0]:  %p\n", last_atom->ddgs, last_atom->ddgs[0]);
  //printf("LA:  %p, NDDGS:  %p, FFN:  %d\n", last_atom, new_ddg_struct, first_free_node);
  last_atom->ddgs[first_free_node]=new_ddg_struct;
  last_atom->addr[first_free_node]=address;
  init_ddg_struct(new_ddg_struct);

  return new_ddg_struct;
}

int count_nodes1(struct ddg_ll *list){
  struct ddg_ll *looper2;
  int looper;
  int nodecount;
  nodecount=0;
  for (looper=0; looper < DDG_HASH_SIZE; looper++){
    for (looper2=&list[looper]; looper2; looper2=looper2->next){
      nodecount++;
    }
  }
  return (nodecount*DDG_LL_ATOM_SIZE);
}

/*kml Dump all nodes in DDG that have producer!=-1*/
void dump_ddg(struct ddg_ll *list){
  struct ddg_ll *looper2;
  int looper, looper3;
  int temp;
  int nodecount;
  nodecount=0;
  fprintf(stderr,"\t\tREMAP TABLE\n");
  fprintf(stderr,"block    || prev     | C | W | REMAP  ||\n");
  fprintf(stderr,"----------------------------------------\n");

  for (looper=0; looper < DDG_HASH_SIZE; looper++)
    for (looper2=&list[looper]; looper2; looper2=looper2->next)
      for (looper3=0; looper3 < DDG_LL_ATOM_SIZE; looper3++)
	if (looper2->ddgs[looper3] && looper2->ddgs[looper3]->event){
	  print_bucket(looper2->ddgs[looper3]);
	  nodecount++;
	}
  fprintf(stdout, "\nTotal nodecount:  %d\n\n", nodecount);
  return;
}

