#include "ddg.h"
#include <stdlib.h>
#include <stdio.h>

static void panic(char *thestring){
  fprintf(stderr, "Error in ddg.c: %s\n", thestring);
  exit(-1);
}

struct ddg_ll *ddg_init(){
  struct ddg_ll *temp;
  struct ddg_struct *new_ddg_struct;
  int looper, looper2;

  temp = (struct ddg_ll *)calloc(DDG_HASH_SIZE, (sizeof(struct ddg_ll)));
  for (looper=0; looper < DDG_HASH_SIZE; looper++) {
    new_ddg_struct = (struct ddg_struct *)calloc(DDG_LL_ATOM_SIZE, 
						 (sizeof(struct ddg_struct)));
    temp[looper].ddgs[0]=new_ddg_struct;
    temp[looper].addr[0]=0;
    init_ddg_struct(new_ddg_struct); /*Change from critical_init*/
    for (looper2=1; looper2 < DDG_LL_ATOM_SIZE; looper2++){
      temp[looper].ddgs[looper2] = NULL;
      temp[looper].addr[looper2] = 0;
    }
    temp[looper].next = NULL;
  }
  return temp;
}

inline struct ddg_struct 
*ddg_get_addr_data(struct ddg_ll *list, md_addr_t address){
  /*This function gets the bucket associated with an address*/
  /*It returns -1 if the bucket isn't found, meaning, this address doesn't have an entry.*/
  int temp;
  struct ddg_ll *looper;
  int looper2;

  temp = DDG_HASH_FUNCTION(address);
  for (looper = &list[temp]; looper != NULL; looper = looper->next){
    for (looper2=0; looper2 < DDG_LL_ATOM_SIZE; looper2++){
      if (!looper->ddgs[looper2])
	return (struct ddg_struct *)-1;
      if (looper->addr[looper2] == address)
	return looper->ddgs[looper2];
    }
  }
  return (struct ddg_struct*)-1;
}

/*This function initializes all values within a ddg struct*/
inline void init_ddg_struct(struct ddg_struct *ddgs){
  int looper;

  for (looper=0; looper < DDG_NUMPROC; looper++){
    ddgs->vector_read[looper]=0;
	ddgs->vector_write[looper]=0;
  }
  ddgs->last=(unsigned char)-1;
  ddgs->last_write=0;
  ddgs->last_read=0;
  ddgs->last_read_pc=0;
  ddgs->last_write_pc=0;
}

/*This function copies a ddg struct from one to another (by value)*/
inline void copy_ddg_struct(struct ddg_struct *dest, struct ddg_struct *src){
  int looper;
  for (looper=0; looper < DDG_NUMPROC; looper++){
    dest->vector_read[looper]=src->vector_read[looper];
	dest->vector_write[looper]=src->vector_write[looper];
  }
  dest->last=src->last;
  dest->last_write=src->last_write;
  dest->last_read=src->last_read;
  dest->last_read_pc=src->last_read_pc;
  dest->last_write_pc=src->last_write_pc;
}

inline struct ddg_struct
*ddg_add_entry(struct ddg_ll *list, md_addr_t address){
  /*This function adds an entry to the linked list passed for the address
    requested.*/

  int temp;
  int first_free_node;
  struct ddg_ll *last_atom;
  struct ddg_ll *looper;
  struct ddg_ll *temp_ddg_ll;
  int looper2;
  //struct ddg_ll *new_ddg_ll;
  struct ddg_struct *new_ddg_struct;
  /*kml do this so that malloc doesn't fragment our space too much*/

  temp = DDG_HASH_FUNCTION(address);
  for (looper = &list[temp]; looper; looper = looper->next) {
    for (looper2=0; looper2 < DDG_LL_ATOM_SIZE; looper2++){
      if (looper->ddgs[looper2]){
	if (looper->addr[looper2] == address)
	  return 0;  /*This entry is already in the table*/
      }
    }
  }

  /*Now loop through again and find the first free place to add a new node*/
  for (looper= &list[temp]; looper->next; looper=looper->next)
    {}
  for (looper2=0; looper2 < DDG_LL_ATOM_SIZE; looper2++){
    if (!looper->ddgs[looper2])
      break;  /*looper2 has the last free node #*/
  }
  first_free_node=looper2;
  last_atom=looper;

  if (!last_atom){
    fprintf(stderr, "No last atom\n");
    exit(-1);
  }

  /*Add this one onto the list*/
  /*Because of the structure, nothing special need be done for the
    first one on the list.*/

  /*curr_entry=curr_entry % DDG_FRAG_SIZE;
  if (curr_entry == 0) {
    oldddgs = calloc(DDG_FRAG_SIZE, sizeof(struct ddg_struct));
    if (!oldddgs){
      fprintf(stderr, "Out of memory allocating storage for a new ddg data list item\n");
      fprintf(stderr, "Approx. Node count:  %d\n", count_nodes1(list));
      exit(-1);
    }    
  }
  new_ddg_struct = oldddgs;
  curr_entry++;
  oldddgs++;
  */

  /*Now see if the current ATOM is full or not, if so, add a new atom*/
  if (first_free_node==DDG_LL_ATOM_SIZE){
    /*Current atom is full, need another one*/
    temp_ddg_ll = (struct ddg_ll *)calloc(1, (sizeof(struct ddg_ll)));
    new_ddg_struct = (struct ddg_struct *)calloc(DDG_LL_ATOM_SIZE, 
						 (sizeof(struct ddg_struct))); 
    if ((!temp_ddg_ll) || (!new_ddg_struct)){
      fprintf(stderr, "Out of memory allocating storage for a new ddg data list item\n");
      fprintf(stderr, "Approx. Node count:  %d\n", count_nodes1(list));
      exit(-1);
    } 
    last_atom->next=temp_ddg_ll;
    for(looper2=0; looper2<DDG_LL_ATOM_SIZE; looper2++){
      temp_ddg_ll->addr[looper2]=0;
      temp_ddg_ll->ddgs[looper2]=NULL;
    }
    temp_ddg_ll->next=NULL;
    first_free_node=0;
    temp_ddg_ll->ddgs[0]=new_ddg_struct;
    last_atom=temp_ddg_ll;
  }

  /*Update new_ddg_struct to be the pointer to the right ddg struct*/
  new_ddg_struct=(last_atom->ddgs[0])+first_free_node;

  /*Now add the new ddg struct onto it*/
  //printf("LA->ddgs:  %p, LA->ddgs[0]:  %p\n", last_atom->ddgs, last_atom->ddgs[0]);
  //printf("LA:  %p, NDDGS:  %p, FFN:  %d\n", last_atom, new_ddg_struct, first_free_node);
  last_atom->ddgs[first_free_node]=new_ddg_struct;
  last_atom->addr[first_free_node]=address;
  init_ddg_struct(new_ddg_struct);

  return new_ddg_struct;
}

int count_nodes1(struct ddg_ll *list){
  struct ddg_ll *looper2;
  int looper, looper3;
  int nodecount;
  nodecount=0;
  for (looper=0; looper < DDG_HASH_SIZE; looper++){
    for (looper2=&list[looper]; looper2; looper2=looper2->next){
      nodecount++;
    }
  }
  return (nodecount*DDG_LL_ATOM_SIZE);
}

/*kml Dump all nodes in DDG that have producer!=-1*/
void dump_ddg(struct ddg_ll *list){
  struct ddg_ll *looper2;
  int looper, looper3;
  int temp;
  int nodecount;
  nodecount=0;
  for (looper=0; looper < DDG_HASH_SIZE; looper++){
    for (looper2=&list[looper]; looper2; looper2=looper2->next){
      for (looper3=0; looper3 < DDG_LL_ATOM_SIZE; looper3++){
	if ((looper2->ddgs[looper3]->last != ((unsigned char)-1)) &&
	    (looper2->addr[looper3] > 0)){
	  fprintf(stdout, "At addr:  %lld, lr: %d, lrt: %lld, lw: %d, lwt: %lld, Vector_w:  ", 
		  looper2->addr[looper3], DDG_LAST_READER(looper2->ddgs[looper3]->last),
		  looper2->ddgs[looper3]->last_read, DDG_LAST_WRITER(looper2->ddgs[looper3]->last),
		  looper2->ddgs[looper3]->last_write);
	  for (temp=0; temp < DDG_NUMPROC; temp++){
	    fprintf(stdout, "%d ", looper2->ddgs[looper3]->vector_write[temp]);
	  }
	  fprintf(stdout, "Vector_lr:  ");
	  for (temp=0; temp < DDG_NUMPROC; temp++){
	    fprintf(stdout, "%d ", looper2->ddgs[looper3]->vector_read[temp]);
	  }
	  fprintf(stdout, "\n");
	  nodecount++;
	}
      }
    }
  }
  fprintf(stdout, "\nTotal nodecount:  %lld\n\n", nodecount);
  return;
}

/*This function prunes inactive nodes from the ddg_ll passed to save memory.  The pruning_value indicates
  that all references with an age older than the prune_value (ie a value lower than it for the
  most recent reader/writer) will be removed*/
unsigned ddg_prune_inactive(struct ddg_ll *list, DDG_TIMESTAMP prune_value){
  struct ddg_ll *ll_looper;
  int hash_entry;
  int looper;
  unsigned removed_nodes=0;
  unsigned shifted_nodes=0;
  struct ddg_ll *prev_used_ddgll=0;
  struct ddg_ll *last_valid_ddgll=0;

  for (hash_entry=0; hash_entry < DDG_HASH_SIZE; hash_entry++){
    /*Find every entry in the hash table that should be removed and mark/tabulate it*/
    for (ll_looper=&list[hash_entry]; ll_looper!=NULL; ll_looper=ll_looper->next){
      for (looper=0; looper < DDG_LL_ATOM_SIZE; looper++){
	if (ll_looper->ddgs[looper]){
	  if ((!ll_looper->addr[looper]) && (looper!=0)){
	    printf("looper:  %d, addr:  %lld\n", looper, ll_looper->addr[looper]);
	    printf("ddgs[looper]:  last:  %d, lrt:  %lld, lwt:  %lld\n",
		   ll_looper->ddgs[looper]->last, ll_looper->ddgs[looper]->last_read,
		   ll_looper->ddgs[looper]->last_write);
	    panic("In ddg_prune, ddgs is non-null, but addr is NULL?");
	  }

	  /*Set the pruning criteria here*/
	  if ((ll_looper->ddgs[looper]->last_read < prune_value) &&
	      (ll_looper->ddgs[looper]->last_write < prune_value)){
	    if (ll_looper->addr[looper]){
	      /*This is one to remove*/
	      /*Tabulate anything here for removed ones that you might want*/

	      /*Now set the address to zero so we know this one is free*/
	      ll_looper->addr[looper]=0;
	      init_ddg_struct(ll_looper->ddgs[looper]);
	      removed_nodes++;
	      if (looper!=0){
		/*if this one doesn't hold the pointer to the malloced part*/
		ll_looper->ddgs[looper]=0;
	      }
	    }
	  }
	} else {
	  ll_looper->addr[looper]=0;  /*Set this just to be sure so following code works*/
	}
      }
    }
    /*Now all entries for this cacheline that have been deleted can be reclaimed.  This won't do
      things very efficiently, but it should work.*/
    /*The algorithm is simple--start from the front of the list.  Find an unused spot, then search
      forward to find a used spot, copy the good data into the new location, and free up the later one*/
    for (ll_looper=&list[hash_entry]; ll_looper!=NULL; ll_looper=ll_looper->next){
      struct ddg_ll *next_used_ddgll=0;
      int next_used_loc=0;
      
      for (looper=0; looper < DDG_LL_ATOM_SIZE; looper++){
	if (!ll_looper->addr[looper]){
	  /*This one is empty, find the next valid entry*/
	  for (next_used_ddgll=ll_looper; next_used_ddgll; next_used_ddgll=next_used_ddgll->next){
	    for (next_used_loc=looper+1; next_used_loc < DDG_LL_ATOM_SIZE; next_used_loc++){
	      if (next_used_ddgll->addr[next_used_loc]!=0)
		break;
	    }
	    if (next_used_loc < DDG_LL_ATOM_SIZE)
	      break;
	  }
	  if (next_used_loc < DDG_LL_ATOM_SIZE) {
	    /*We found a used node, copy it and free it*/
	    /*printf("ll_l:  %p, nucll:  %p, looper:  %d, nul:  %d\n",
	           ll_looper, next_used_cll, looper, next_used_loc);*/
	    /*kml 11/19/2000 Need to recalc. ddgs[looper] if looper != 0 because it
	      may have been freed above.  However, the base address for this ATOM is
	      still available at location 0*/
	    ll_looper->ddgs[looper]=ll_looper->ddgs[0]+looper;
	    copy_ddg_struct(ll_looper->ddgs[looper], next_used_ddgll->ddgs[next_used_loc]);
	    ll_looper->addr[looper]=next_used_ddgll->addr[next_used_loc];
	    next_used_ddgll->addr[next_used_loc]=0;
	    shifted_nodes++;
	  }
	}
      }
    }
    /*Now we need to free all the space allocated on un-used nodes*/
    last_valid_ddgll=&list[hash_entry];
    for (ll_looper=&list[hash_entry]; ll_looper!=NULL; ll_looper=ll_looper->next){
      if (!ll_looper->addr[0]){
	for (looper=0; looper < DDG_LL_ATOM_SIZE; looper++){
	  if (ll_looper->addr[looper])
	    panic("Going to blow away in critical in silent.c, but the sublist isn't empty?");
	}
      }
      if ((!ll_looper->addr[0])&&(ll_looper!=(&list[hash_entry]))){
	free(ll_looper->ddgs[0]);
	ll_looper->ddgs[0]=0;
	if (prev_used_ddgll){
	  free(prev_used_ddgll);
	}
	prev_used_ddgll=ll_looper;
      } else {
	last_valid_ddgll=ll_looper;
      }
    }
    last_valid_ddgll->next=NULL;  /*Need to mark last valid one as the last one*/
    /*Also go through the last valid one and be sure there are no orphan cs[] entries with old
      pointer values in them from the shifting operations*/
    for (looper=1; looper < DDG_LL_ATOM_SIZE; looper++){
      if (!(last_valid_ddgll->addr[looper]))
	last_valid_ddgll->ddgs[looper]=0;
    }
  }
  printf("In ddg_prune, number of shifted nodes:  %d, removed nodes:  %d\n", shifted_nodes, removed_nodes);
  return removed_nodes;
}


