#ifndef DDG_H
#define DDG_H

#include "kml_typedef.h"
/*kml Number of processors in the simulation, used in DDG vectors*/
#define DDG_NUMPROC 4
/*kml WARNING:  If you want more than 15 CPU, need to change size of "last" and
  the DDG_LAST_<whatever> functions!*/
#define DDG_COLD_PROC_VAL 15
/*kml this is the value in the LAST_<whatever> that indicates it hasn't been read/written before.
  It is actually whatever the size of "last" is cut in half, the unsigned maximum representation
  because last is initialized with -1*/
typedef unsigned int DDG_VEC_TYPE ;
typedef unsigned int DDG_TIMESTAMP ;

/*kml These pick out the last reader/writer cpu id from the "last" field*/
#define DDG_LAST_WRITER(N) (unsigned)(N & 0xf)
#define DDG_LAST_READER(N) (unsigned)((N & 0xf0) >> 4)
#define DDG_SET_LAST_WRITER(N, P) (N = (unsigned char)((N & 0xf0) | (P & 0xf)))
#define DDG_SET_LAST_READER(N, P) (N = (unsigned char)((N & 0x0f) | ((P & 0xf) << 4)))

struct ddg_struct {
  /*If you add things here, be sure you put it in the "copy" function in ddg.c, in the ddg_init
    and also in the ddg_ll_init!*/
  DDG_VEC_TYPE vector_write[DDG_NUMPROC];  /*Dependence vector at last write*/
  DDG_VEC_TYPE vector_read[DDG_NUMPROC];  /*Dependence vector at last read*/ /*kml 11/19/2000 added*/
  unsigned char last; /*Last processor to read/write.  Use defines above to access*/
  DDG_TIMESTAMP last_read; /*Cycle count that indicates when last read/written*/
  DDG_TIMESTAMP last_write;
  unsigned long long last_read_pc; /*PC of the last reader*/
  unsigned long long last_write_pc; /*PC of the last writer*/
};

/*The number of entries to group together for space savings*/
#define DDG_LL_ATOM_SIZE 5
struct ddg_ll {
  struct ddg_ll *next;
  md_addr_t addr[DDG_LL_ATOM_SIZE];
  struct ddg_struct * ddgs[DDG_LL_ATOM_SIZE];
};

#define DDG_HASH_SIZE      		2048
#define DDG_HASH_FUNCTION(I)       	((((I & (~31)) >> 8) ^ (I & (~31))) & (DDG_HASH_SIZE - 1))

struct ddg_ll * ddg_init();
inline struct ddg_struct *ddg_get_addr_data(struct ddg_ll *list, md_addr_t address);
inline void init_ddg_struct(struct ddg_struct *cs);
inline struct ddg_struct *ddg_add_entry(struct ddg_ll *list, md_addr_t address);
int count_nodes1(struct ddg_ll *list);
void dump_ddg(struct ddg_ll *list);
unsigned ddg_prune_inactive(struct ddg_ll *list, unsigned prune_value);

#endif






