/* Gordon Bell */
/* disk replication project */
/* CS736 */

#include "disksim_global.h"
/* #include "repl.h" */
#include "ddg.h"

#define DEBUG
#define NUM_REMAPS 2
#define THRESHOLD 2

bucket last_block;
static int init = 1;
struct ddg_ll *remap_table;

bucket NewBucket(ioreq_event *event){
  bucket temp = malloc(sizeof(struct _bucket));
  temp->count = 0;
  temp->write = 0;
  temp->event = event;
  temp->prev = NULL;
  temp->next = NULL;
  return temp;
}

/* should pass in **curr so can modify io_req it points to? */
ioreq_event *remap(ioreq_event *curr){

  ioreq_event *ret;

  if (init){
    remap_table = ddg_init();
    repl_init();
    init = 0;
  }
  
  if (!curr){
    fprintf(stderr,"null ioreq_event passed to remap\n");
    exit(0);
  }

  curr = copy_io(curr);

  if (curr->flags & READ)
    ret = process_read(curr);
  else if (!curr->flags)
    ret = process_write(curr);
  else{  /* ignore non READ /WRITE ops? can do? */
    fprintf(stderr,"processing non RD/WR\n");
    print_ioreq_event(curr);
    ret = curr;
  }
#ifdef DEBUG
  fprintf(stderr,"dumping remap_table\n");
  dump_ddg(remap_table);
  fprintf(stderr,"============================\n");
#endif

  return ret;
}

void print_bucket(bucket thebucket){

  if (!thebucket || !thebucket->event){
    fprintf(stderr,"ERROR thebucket or thebucket->event does not exist\n");
    exit(0);
  }

  fprintf(stderr,"%-9d", thebucket->event->blkno);
  fprintf(stderr,"|| ");
  thebucket = thebucket->next;
 
  while (thebucket){
    if (thebucket->prev == (bucket)-1)
      fprintf(stderr,"-1");
    else if(!thebucket->prev){
      fprintf(stderr,"ERROR: why is thebucket->prev == NULL? should be -1\n");
      exit(0);
    }

    if (!thebucket->prev->event){
      fprintf(stderr,"ERROR: why is thebucket->prev->event == NULL? should be -1\n");
      exit(0);
    }
    else if (thebucket->prev->event == (ioreq_event*)-1)
      fprintf(stderr,"-1       ");
    else
      fprintf(stderr,"%-9d", thebucket->prev->event->blkno);
    fprintf(stderr,"| ");
    fprintf(stderr,"%-2d", thebucket->count);
    fprintf(stderr,"| ");
    fprintf(stderr,"%-2d", thebucket->write);
    fprintf(stderr,"| ");
    
    if (!thebucket->event){
      fprintf(stderr,"ERROR: thebucket->event == NULL\n");
      exit(0);
    }
    else if (thebucket->event == (ioreq_event*)-1)
      fprintf(stderr,"-1     ");
    else
      fprintf(stderr,"%-9d", thebucket->event->blkno);

    fprintf(stderr,"|| ");
    thebucket = thebucket->next;
  }
  fprintf(stderr,"+\n");
}

void print_ioreq_event(ioreq_event *curr){

  if (!curr){
    fprintf(stderr,"null ioreq_event passed to print_ioreq_event\n");
    exit(0);
  }
  else if (curr == (ioreq_event*)-1){
    fprintf(stderr,"no ioreq_event to print (-1)\n");
    return;
  }
  
  fprintf(stderr,"time: %f; devno: %d; blkno: %d; bcount: %d\n",
	 curr->time, curr->devno, curr->blkno, curr->bcount);
}

ioreq_event *process_read(ioreq_event *curr){
  bucket temp;
  bucket looper;
  bucket ret = NULL;

#ifdef DEBUG
  fprintf(stderr,"processing READ!!\n");
  print_ioreq_event(curr);
#endif

  temp = ddg_get_addr_data(remap_table, curr->blkno);

  if (temp == (bucket)-1){ /* not found, make new entry */
    temp = ddg_add_entry(remap_table, curr->blkno);
    if (!temp){
      fprintf(stderr,"ddg_add_entry returned null: in table?\n");
      exit(0);
    }
    fill_bucket(temp, -1, 0, curr, (bucket)-1, NULL);
#ifdef DEBUG
    fprintf(stderr,"block: %d not found, creating new bucket\n", curr->blkno);
#endif
  }
  else{   /* found in hash table */

    /* need this because Spanky's code doesn't handle a search */
    /* of key 0 in the hash table well */
    if (!temp->count)
      fill_bucket(temp, -1, 0, curr, (bucket)-1, NULL);
    
    if (temp->event->blkno != curr->blkno){
      fprintf(stderr,"ERROR: blk # of curr and ht lookup don't match\n");
      exit(0);
    }
  }
  
  /* look for entries that match last_block */  
  for (looper=temp; looper; looper=looper->next)
    if (looper->prev == last_block){
#ifdef DEBUG
      fprintf(stderr,"found match: block [%d] and last_block [%d]\n", temp->event->blkno, last_block->event->blkno);
#endif
      looper->count++;
      if (looper->count >= THRESHOLD)
	/* add this to prop queue */
#ifdef DEBUG
	fprintf(stderr,"block: %d exceeds threshold\n", temp->event->blkno);
#endif
	;
      if (!ret || (ret && (ret->count >= looper->count)))
	ret = looper;
      break;
    }
  
  /* no entries with matching last_block, so insert into end of list */
  if (!looper){
    for (looper=temp; looper->next; looper=looper->next) ;
    looper->next = NewBucket(NULL);
    fill_bucket(looper->next, 1, 0, (ioreq_event*)-1, last_block, NULL);
  }

  /* move this to write as well */
  last_block = temp;
  if (!ret)
    return temp->event;
  else
    return ret->event;}
    
void fill_bucket(bucket Bucket, int count, int write, ioreq_event *event, bucket prev, bucket next){
  Bucket->count = count;
  Bucket->write = write;
  Bucket->event = event;
  Bucket->prev = prev;
  Bucket->next = next;
}

ioreq_event *process_write(ioreq_event *curr){
  fprintf(stderr,"processing WRITE!!\n");
  print_ioreq_event(curr);

  

  return curr; /* temp */
}

ioreq_event *copy_io(ioreq_event *curr){
  ioreq_event *ret;
  ret = malloc(sizeof(ioreq_event));

  if (!ret){
    fprintf(stderr,"ERROR: out of mem\n");
    exit(0);
  }

  ret->time = curr->time;
  ret->type = curr->type;
  ret->next = curr->next;
  ret->prev = curr->prev;
  ret->bcount = curr->bcount;
  ret->blkno = curr->blkno;
  ret->flags = curr->flags;
  ret->busno = curr->busno;
  ret->slotno = curr->slotno;
  ret->devno = curr->devno;
  ret->opid = curr->opid;
  ret->buf = curr->buf;
  ret->cause = curr->cause;
  ret->tempint1 = curr->tempint1;
  ret->tempint2 = curr->tempint2;
  ret->tempptr1 = curr->tempptr1;
  ret->tempptr2 = curr->tempptr2;

  return ret;
}

void repl_init(){
  last_block = NewBucket((ioreq_event*)-1);
  last_block->prev = (bucket)-1;
}











