// ************************
// disk_access.cc
//
// DESCRIPTION:
//    Holds the subroutines for the class that reads in and contains a disk 
//    access from a disk trace.
//
// REVISION HISTORY:
//    0.0  11/29/00  Morris Marden   Initial Revision
//    0.1  12/04/00  Morris Marden   Changed so now can handle trace files in
//                                   ASCII format
// ************************

// *** INCLUDES ***

#include <stdlib.h>
#include <iostream.h>
#include <fstream.h>
#include <stream.h>
#include <string.h>
#include "disk_access.h"


// *** CLASS SUBROUTINES ***

// Constructor for the disk access class.  Note that requires give a pointer
//   to the file that contains the trace.
DiskAccess::DiskAccess(ifstream *traceFile)
{
  bool legalAccess = true; // holds whether access was legal

#if (FILE_FORMAT == ASCII_FORMAT)
  // get the time of the access
  if (!(*traceFile >> requestTime))
    legalAccess = false;
  
  // get the device number for the access
  if (!(*traceFile >> deviceNum))
    legalAccess = false;

  // get the block number of the request
  if (!(*traceFile >> blockNum))
    legalAccess = false;

  // get the size of the access
  if (!(*traceFile >> accessSize))
    legalAccess = false;

  if (!(*traceFile >> accessFlags))
    legalAccess = false;
#endif

#if (FILE_FORMAT == VALIDATE_FORMAT)
  char accessTypeChar;     // holds a char that indicates the access type

  // get the access type
  if (*traceFile >> accessTypeChar) 
  {
    if (accessTypeChar == READ_CHAR)
      myType = READ;
    else if (accessTypeChar == WRITE_CHAR)
      myType = WRITE;
    else // illegal access type
    {
      cerr << "Error: attempted to perform illegal type of access" << endl;
      legalAccess = false;
    }
  }
  else
    legalAccess = false;

  // only bother to get rest of info about access if legal
  if (legalAccess)
  {
    bufAction = new char[4];
    char temp;
    for (int loop = 0; loop < 3; loop++)
    {
      *traceFile >> temp;
      bufAction[loop] = temp;
    }
    bufAction[3] = '\0';
//    if (!(*traceFile >> bufAction))
//      legalAccess = false;
    if (!(*traceFile >> blockNum))
      legalAccess = false;
    if (!(*traceFile >> accessSize))
      legalAccess = false;
    if (!(*traceFile >> requestTime))
      legalAccess = false;
    if (!(*traceFile >> nextInterrupt))
      legalAccess = false;
  }
#endif

  // if the access was not legal
  if (!legalAccess)
  {
    myType = NONE;
    blockNum = ACCESS_ERROR;
    accessSize = ACCESS_ERROR;
    requestTime = ACCESS_ERROR;
    nextInterrupt = ACCESS_ERROR;
#if (FILE_FORMAT == ASCII_FORMAT)
    deviceNum = ACCESS_ERROR;
    accessFlags = ACCESS_ERROR;
#endif

#if (FILE_FORMAT == VALIDATE_FORMAT)
    bufAction = "";
#endif
  }
}

// destructor for the disk access class
DiskAccess::~DiskAccess()
{
#if (FILE_FORMAT == VALIDATE_FORMAT)
  delete bufAction;
#endif
}

// GetAccessSize: return the size of the access
int DiskAccess::GetAccessSize()
{
  return(accessSize);
}

// GetBlockNum: return the block number for the access
int DiskAccess::GetBlockNum()
{
  return (blockNum);
}
