// ************************
// disk_access.h
//
// DESCRIPTION:
//    Holds the class that reads in and contains a disk access from a disk 
//    trace.
//
// REVISION HISTORY:
//    0.0  11/29/00  Morris Marden   Initial Revision
//    0.1  12/04/00  Morris Marden   Changed so now can handle trace files in
//                                   ASCII format
// ************************

// *** GUARD ***

#ifndef DISK_ACCESS_GUARD
#define DISK ACCESS_GUARD


// *** INCLUDES ***

#include <iostream.h>
#include <fstream.h>


// *** CONSTANTS ***

#define ACCESS_ERROR     -1  // holds that access was not legal

#define READ_CHAR        'R' // holds that access was a read
#define WRITE_CHAR       'W' // holds that access was a write

// format of the trace files
#define VALIDATE_FORMAT  1   
#define ASCII_FORMAT     2
#define FILE_FORMAT      ASCII_FORMAT


// *** ENUMERATIONS ***

// AccessType: type of the disk access (read or write)
enum AccessType {NONE, READ, WRITE};


// *** CLASS DEFINITIONS

class DiskAccess {
 private:
  AccessType  myType;        // type of the access
  int         blockNum;      // block number of first block to access
  int         accessSize;    // number of blocks accessed
  float       requestTime;   // time (in ms from beginning of sim) of request
  float       nextInterrupt; // time next interrupt occurs (?)

#if (FILE_FORMAT == ASCII_FORMAT)
  int         deviceNum;     // device number of the request
  int         accessFlags;   // flags for the access
#endif

#if (FILE_FORMAT == VALIDATE_FORMAT)
  char        *bufAction;    // type of buffer action (?)
#endif

 public:
  DiskAccess(ifstream *traceFile);  // constructor
  ~DiskAccess();                    // destructor

  int GetAccessSize();       // get the size of the access
  int GetBlockNum();         // get the block number of the access
};


// *** END GUARD ***

#endif
