// **********************
// main.cc
//
// DESCRIPTION:
//   Holds the main subroutine, which reads in the arguements to the program
//   and calls the appropriate routines to compute stats on trace use.
//
// REVISION HISTORY:
//   0.0  12/02/00  Morris Marden   Initial Revision
// **********************

// *** INCLUDES ***

#include <stdlib.h>
#include <iostream.h>
#include <stream.h>
#include <string.h>
#include "trace.h"


// *** CONSTANTS ***

#define MIN_NUM_ARGS  4   // minimum # of arguements from user


// *** MAIN ROUTINE ***

int main (int argc, char **argv)
{
  char            *traceFileName; // name of the file holding the disk trace
  char            *statsFileName; // name of the file for outputting stats
  int             maxTraceLen;    // maximum length of a trace
  StatsCollector  theCollector;   // stats collector

  // make sure that user gave enough arguements
  if (argc < MIN_NUM_ARGS)
  {
    cerr << "Error, not enough arguements, usage:" << endl;
    cerr << "\t" << argv[0] << "<input file name> <max trace length> ";
    cerr << "<output file name>" << endl;
    exit(1);
  }

  // parse the arguements from the user
  traceFileName = argv[1];      // get the name of the file
  maxTraceLen = atoi(argv[2]);  // get the maximum length of a trace
  if (maxTraceLen <= 0)
  {
    cerr << "Error, the maxmimum trace length must be set to a positive,";
    cerr << " non-zero integer." << endl;
    exit(1);
  }
  statsFileName = argv[3];

  // collect stats on the traces of temporally local accesses from the disk 
  //   trace
  theCollector.TraceSim(traceFileName, maxTraceLen);
  
  // gather the stats and send them to the output file
  theCollector.GatherStats(statsFileName, maxTraceLen);
}

