// ************************
// trace.cc
//
// DESCRIPTION:
//    Holds the subroutines for the class that holds the traces of temporally 
//    local disk accesses and the associated counters for the traces.
//
// REVISION HISTORY:
//    0.0  12/01/00  Morris Marden   Initial Revision
// ************************

// *** INCLUDES ***

#include <stdlib.h>
#include "trace.h"


// *** CLASS SUBROUTINES ***

// -- Trace --

// constructor for the trace class
Trace::Trace(int theBlockNum)
{
  count = 1;  // seen the block once if here
  blockNum = theBlockNum;

  nextBlock = NULL;
  nextAltBlock = NULL;
}

// destructor for the trace class
Trace::~Trace()
{
//  Trace *currAltBlock = NULL;  // current alternate block deleting

//  delete nextBlock;    // delete the next blocks in the trace
//  delete nextAltBlock; // delete the alternate blocks in the parent's trace

  // delete the alternate blocks, can't use above call, since data struct so
  //  large that recursive calls will overflow stack
/*******
  currAltBlock = nextAltBlock;
  while (currAltBlock != NULL)
  {
    // pop current block off of list
    nextAltBlock = currAltBlock->nextAltBlock;
    currAltBlock->nextAltBlock = NULL;
    delete currAltBlock;
    // get the next alternate block
    currAltBlock = nextAltBlock;
  }
*******/
}

// IncrCount: increments the count of number of times seen block in trace
void Trace::IncrCount()
{
  count++;
}

// GetCount: returns count of number of times seen block in trace
int Trace::GetCount()
{
  return(count);
}

// GetBlockNum: returns the block number of the block
int Trace::GetBlockNum()
{
  return(blockNum);
}

// BlockSearch: looks in the trace for a particular block.  If finds, returns 
//    a pointer to the trace holding the block.  Otherwise, returns NULL.
Trace * Trace::BlockSearch(int searchBlockNum)
{
  Trace *result = NULL;   // result of search

  // look for the trace that starts with the desired block
  result = this;     // point to the first possible trace could be
  while (result != NULL)
  {
    // check if found the block
    if (result->blockNum == searchBlockNum)
      break;    // found block, so done
    // otherwise keep looking, so point to next possible trace
    result = result->nextAltBlock;
  }
  
  // finished search, so return the result
  return (result);
}

// -- TracePtrList --

// constructor for the list of pointers to elements in the trace datastruct
TracePtrList::TracePtrList(Trace *thePtr)
{
  myTracePtr = thePtr;
  next = NULL;
}

// destructor for the list of pointers to elements in the trace datastruct
TracePtrList::~TracePtrList()
{
  myTracePtr = NULL;  // don't delete element of trace datastruct
  delete next;
}
