/*
 * Decompiled with CFR 0.152.
 */
package com.macmillan.nmeyers;

import com.macmillan.nmeyers.PerfTree;
import com.macmillan.nmeyers.Procedure;
import com.macmillan.nmeyers.TraceBack;
import java.text.DecimalFormat;
import java.util.AbstractList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

class CalleeInclusive
extends PerfTree.PerfTreeNode
implements Comparable {
    HashMap kidInfo = new HashMap();

    private CalleeInclusive(ProcCountInfo procCountInfo) {
        super(procCountInfo);
    }

    CalleeInclusive(HashMap hashMap, int n) {
        super(new ProcCountInfo(new Procedure("")));
        Comparable comparable;
        ((ProcCountInfo)this.getUserObject()).count = n;
        Iterator<Object> iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            comparable = new ProcCountInfo((Procedure)iterator.next());
            this.add((ProcCountInfo)comparable);
        }
        if (this.children == null) {
            return;
        }
        iterator = ((AbstractList)this.children).iterator();
        while (iterator.hasNext()) {
            comparable = (CalleeInclusive)iterator.next();
            Procedure.TraceInfo traceInfo = null;
            Iterator iterator2 = ((ProcCountInfo)((DefaultMutableTreeNode)((Object)comparable)).getUserObject()).procedure.myTraces.iterator();
            while (iterator2.hasNext()) {
                Procedure.TraceInfo traceInfo2 = (Procedure.TraceInfo)iterator2.next();
                if (traceInfo != null && !traceInfo.traceBack.equals(traceInfo2.traceBack)) {
                    super.addDescendants(traceInfo.traceBack, traceInfo.depth + 1);
                }
                traceInfo = traceInfo2;
            }
            if (traceInfo == null) continue;
            super.addDescendants(traceInfo.traceBack, traceInfo.depth + 1);
        }
        this.processNodes();
    }

    private CalleeInclusive add(ProcCountInfo procCountInfo) {
        CalleeInclusive calleeInclusive = new CalleeInclusive(procCountInfo);
        this.kidInfo.put(procCountInfo.procedure.procName, new KidInfo(procCountInfo.procedure.procName, calleeInclusive));
        this.add(calleeInclusive);
        return calleeInclusive;
    }

    private void addDescendants(TraceBack traceBack, int n) {
        if (traceBack.thread != null && !traceBack.thread.enabled) {
            return;
        }
        if (n < traceBack.entries.size()) {
            String string = ((TraceBack.TraceBackEntry)traceBack.entries.get((int)n)).procName;
            KidInfo kidInfo = (KidInfo)this.kidInfo.get(string);
            CalleeInclusive calleeInclusive = kidInfo == null ? this.add(new ProcCountInfo(new Procedure(string))) : kidInfo.kid;
            calleeInclusive.addDescendants(traceBack, n + 1);
        } else {
            ((ProcCountInfo)this.getUserObject()).myCount += traceBack.traceCount;
        }
    }

    public int compareTo(Object object) {
        return ((ProcCountInfo)this.getUserObject()).compareTo(((PerfTree.PerfTreeNode)object).getUserObject());
    }

    TreePath findThisProc(String string) {
        Iterator iterator = ((AbstractList)this.children).iterator();
        while (iterator.hasNext()) {
            CalleeInclusive calleeInclusive = (CalleeInclusive)iterator.next();
            ProcCountInfo procCountInfo = (ProcCountInfo)calleeInclusive.getUserObject();
            if (!procCountInfo.procedure.procName.equals(string)) continue;
            return new TreePath(calleeInclusive.getPath());
        }
        return null;
    }

    public String getProcName() {
        return ((ProcCountInfo)this.getUserObject()).procedure.procName;
    }

    private void processNodes() {
        this.kidInfo = null;
        ProcCountInfo procCountInfo = (ProcCountInfo)this.getUserObject();
        if (this.getLevel() > 0) {
            procCountInfo.count = procCountInfo.myCount;
        }
        if (this.children != null) {
            ListIterator listIterator = ((AbstractList)this.children).listIterator();
            while (listIterator.hasNext()) {
                CalleeInclusive calleeInclusive = (CalleeInclusive)listIterator.next();
                ProcCountInfo procCountInfo2 = (ProcCountInfo)calleeInclusive.getUserObject();
                calleeInclusive.processNodes();
                if (this.getLevel() <= 0) continue;
                procCountInfo.count += procCountInfo2.count;
            }
            Collections.sort(this.children);
        }
    }

    public String toString() {
        ProcCountInfo procCountInfo = (ProcCountInfo)((PerfTree.PerfTreeNode)this.getRoot()).getUserObject();
        if (this.getLevel() == 0) {
            return "Method Times by Callee (times inclusive): " + procCountInfo.count + " ticks";
        }
        ProcCountInfo procCountInfo2 = (ProcCountInfo)this.getUserObject();
        return procCountInfo2.toString(procCountInfo.count);
    }

    static class ProcCountInfo
    implements Comparable {
        Procedure procedure;
        int count = 0;
        int myCount = 0;
        static DecimalFormat format = new DecimalFormat("##0.##%");

        ProcCountInfo(Procedure procedure) {
            this.procedure = procedure;
        }

        public int compareTo(Object object) {
            return ((ProcCountInfo)object).count - this.count;
        }

        public boolean equals(Object object) {
            return this.count == ((ProcCountInfo)object).count;
        }

        public String toString(int n) {
            return String.valueOf(this.procedure.procName) + ": " + format.format((double)this.count / (double)n) + " (" + this.count + " inclusive)";
        }
    }

    static class KidInfo
    implements Comparable {
        String kidName;
        CalleeInclusive kid;

        KidInfo(String string, CalleeInclusive calleeInclusive) {
            this.kidName = string;
            this.kid = calleeInclusive;
        }

        public int compareTo(Object object) {
            return this.kidName.compareTo(((KidInfo)object).kidName);
        }
    }
}

