/*
 * Decompiled with CFR 0.152.
 */
package com.macmillan.nmeyers;

import com.macmillan.nmeyers.PerfTree;
import com.macmillan.nmeyers.Procedure;
import com.macmillan.nmeyers.TraceBack;
import java.text.DecimalFormat;
import java.util.AbstractList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

class CallerInclusive
extends PerfTree.PerfTreeNode
implements Comparable {
    HashMap kidInfo = new HashMap();

    private CallerInclusive(ProcCountInfo procCountInfo) {
        super(procCountInfo);
    }

    CallerInclusive(HashMap hashMap, int n) {
        super(new ProcCountInfo(new Procedure("")));
        Comparable comparable;
        ((ProcCountInfo)this.getUserObject()).count = n;
        Iterator<Object> iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            comparable = new ProcCountInfo((Procedure)iterator.next());
            this.add((ProcCountInfo)comparable);
        }
        if (this.children == null) {
            return;
        }
        iterator = ((AbstractList)this.children).iterator();
        while (iterator.hasNext()) {
            comparable = (CallerInclusive)iterator.next();
            Procedure.TraceInfo traceInfo = null;
            Iterator iterator2 = ((ProcCountInfo)((DefaultMutableTreeNode)((Object)comparable)).getUserObject()).procedure.myTraces.iterator();
            while (iterator2.hasNext()) {
                Procedure.TraceInfo traceInfo2 = (Procedure.TraceInfo)iterator2.next();
                if (traceInfo != null && traceInfo.traceBack.equals(traceInfo2.traceBack)) continue;
                traceInfo = traceInfo2;
                super.addDescendants(traceInfo2.traceBack, traceInfo2.depth - 1);
            }
        }
        this.processNodes();
    }

    private CallerInclusive add(ProcCountInfo procCountInfo) {
        CallerInclusive callerInclusive = new CallerInclusive(procCountInfo);
        this.kidInfo.put(procCountInfo.procedure.procName, new KidInfo(procCountInfo.procedure.procName, callerInclusive));
        this.add(callerInclusive);
        return callerInclusive;
    }

    private void addDescendants(TraceBack traceBack, int n) {
        if (traceBack.thread != null && !traceBack.thread.enabled) {
            return;
        }
        if (n >= 0) {
            String string = ((TraceBack.TraceBackEntry)traceBack.entries.get((int)n)).procName;
            KidInfo kidInfo = (KidInfo)this.kidInfo.get(string);
            CallerInclusive callerInclusive = kidInfo == null ? this.add(new ProcCountInfo(new Procedure(string))) : kidInfo.kid;
            callerInclusive.addDescendants(traceBack, n - 1);
        } else {
            ((ProcCountInfo)this.getUserObject()).myCount += traceBack.traceCount;
        }
    }

    public int compareTo(Object object) {
        return ((ProcCountInfo)this.getUserObject()).compareTo(((PerfTree.PerfTreeNode)object).getUserObject());
    }

    TreePath findThisProc(String string) {
        Iterator iterator = ((AbstractList)this.children).iterator();
        while (iterator.hasNext()) {
            CallerInclusive callerInclusive = (CallerInclusive)iterator.next();
            ProcCountInfo procCountInfo = (ProcCountInfo)callerInclusive.getUserObject();
            if (!procCountInfo.procedure.procName.equals(string)) continue;
            return new TreePath(callerInclusive.getPath());
        }
        return null;
    }

    public String getProcName() {
        return ((ProcCountInfo)this.getUserObject()).procedure.procName;
    }

    private void processNodes() {
        this.kidInfo = null;
        ProcCountInfo procCountInfo = (ProcCountInfo)this.getUserObject();
        if (this.getLevel() > 0) {
            procCountInfo.count = procCountInfo.myCount;
        }
        if (this.children != null) {
            ListIterator listIterator = ((AbstractList)this.children).listIterator();
            while (listIterator.hasNext()) {
                CallerInclusive callerInclusive = (CallerInclusive)listIterator.next();
                ProcCountInfo procCountInfo2 = (ProcCountInfo)callerInclusive.getUserObject();
                callerInclusive.processNodes();
                if (this.getLevel() <= 0) continue;
                procCountInfo.count += procCountInfo2.count;
            }
            Collections.sort(this.children);
        }
    }

    public String toString() {
        ProcCountInfo procCountInfo = (ProcCountInfo)((PerfTree.PerfTreeNode)this.getRoot()).getUserObject();
        if (this.getLevel() == 0) {
            return "Method Times by Caller (times inclusive): " + procCountInfo.count + " ticks";
        }
        ProcCountInfo procCountInfo2 = (ProcCountInfo)this.getUserObject();
        return procCountInfo2.toString(procCountInfo.count);
    }

    static class ProcCountInfo
    implements Comparable {
        Procedure procedure;
        int count = 0;
        int myCount = 0;
        static DecimalFormat format = new DecimalFormat("##0.##%");

        ProcCountInfo(Procedure procedure) {
            this.procedure = procedure;
        }

        public int compareTo(Object object) {
            return ((ProcCountInfo)object).count - this.count;
        }

        public boolean equals(Object object) {
            return this.count == ((ProcCountInfo)object).count;
        }

        public String toString(int n) {
            return String.valueOf(this.procedure.procName) + ": " + format.format((double)this.count / (double)n) + " (" + this.count + " inclusive / " + this.myCount + " exclusive)";
        }
    }

    static class KidInfo
    implements Comparable {
        String kidName;
        CallerInclusive kid;

        KidInfo(String string, CallerInclusive callerInclusive) {
            this.kidName = string;
            this.kid = callerInclusive;
        }

        public int compareTo(Object object) {
            return this.kidName.compareTo(((KidInfo)object).kidName);
        }
    }
}

