/*
 * Decompiled with CFR 0.152.
 */
package com.macmillan.nmeyers;

import com.macmillan.nmeyers.PerfTree;
import com.macmillan.nmeyers.Procedure;
import java.text.DecimalFormat;
import java.util.AbstractList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.tree.TreePath;

class LineExclusive
extends PerfTree.PerfTreeNode
implements Comparable {
    private LineExclusive(ProcCountInfo procCountInfo) {
        super(procCountInfo);
    }

    LineExclusive(HashMap hashMap, int n) {
        super(new ProcCountInfo("", n));
        Iterator iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            Procedure procedure = (Procedure)iterator.next();
            ProcCountInfo procCountInfo = new ProcCountInfo(procedure.procName, 0);
            LineExclusive lineExclusive = new LineExclusive(procCountInfo);
            this.add(lineExclusive);
            Iterator iterator2 = procedure.lines.iterator();
            ProcCountInfo procCountInfo2 = null;
            while (iterator2.hasNext()) {
                Procedure.Line line = (Procedure.Line)iterator2.next();
                if (line.thread != null && !line.thread.enabled) continue;
                procCountInfo.count += line.countExclusive;
                if (procCountInfo2 != null && procCountInfo2.procName.equals(line.lineInfo)) {
                    procCountInfo2.count += line.countExclusive;
                    continue;
                }
                procCountInfo2 = new ProcCountInfo(line.lineInfo, line.countExclusive);
                lineExclusive.add(new LineExclusive(procCountInfo2));
            }
            if (lineExclusive.children == null) continue;
            Collections.sort(lineExclusive.children);
        }
        if (this.children != null) {
            Collections.sort(this.children);
        }
    }

    public int compareTo(Object object) {
        return ((ProcCountInfo)this.getUserObject()).compareTo(((PerfTree.PerfTreeNode)object).getUserObject());
    }

    TreePath findThisProc(String string) {
        Iterator iterator = ((AbstractList)this.children).iterator();
        while (iterator.hasNext()) {
            LineExclusive lineExclusive = (LineExclusive)iterator.next();
            ProcCountInfo procCountInfo = (ProcCountInfo)lineExclusive.getUserObject();
            if (!procCountInfo.procName.equals(string)) continue;
            return new TreePath(lineExclusive.getPath());
        }
        return null;
    }

    public String getProcName() {
        if (this.getLevel() > 1) {
            return ((PerfTree.PerfTreeNode)this.getParent()).getProcName();
        }
        return ((ProcCountInfo)this.getUserObject()).procName;
    }

    public String toString() {
        ProcCountInfo procCountInfo = (ProcCountInfo)((PerfTree.PerfTreeNode)this.getRoot()).getUserObject();
        if (this.getLevel() == 0) {
            return "Method Times by Line Number (times exclusive): " + procCountInfo.count + " ticks";
        }
        ProcCountInfo procCountInfo2 = (ProcCountInfo)this.getUserObject();
        return procCountInfo2.toString(procCountInfo.count);
    }

    static class ProcCountInfo
    implements Comparable {
        String procName;
        int count;
        static DecimalFormat format = new DecimalFormat("##0.##%");

        ProcCountInfo(String string, int n) {
            this.procName = string;
            this.count = n;
        }

        public int compareTo(Object object) {
            return ((ProcCountInfo)object).count - this.count;
        }

        public boolean equals(Object object) {
            return this.count == ((ProcCountInfo)object).count;
        }

        public String toString(int n) {
            return String.valueOf(this.procName) + ": " + format.format((double)this.count / (double)n) + " (" + this.count + " exclusive)";
        }
    }
}

