/*
 * Decompiled with CFR 0.152.
 */
package com.macmillan.nmeyers;

import com.macmillan.nmeyers.CalleeInclusive;
import com.macmillan.nmeyers.CallerInclusive;
import com.macmillan.nmeyers.LineExclusive;
import com.macmillan.nmeyers.LineInclusive;
import com.macmillan.nmeyers.PerfTree;
import com.macmillan.nmeyers.Procedure;
import com.macmillan.nmeyers.SaveDialog;
import com.macmillan.nmeyers.SelectMethod;
import com.macmillan.nmeyers.SelectThreads;
import com.macmillan.nmeyers.ThreadInfo;
import com.macmillan.nmeyers.TraceBack;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.RootPaneContainer;

class PerfAnal
extends JFrame
implements PerfTree.FindMethod,
SaveDialog.DoSave,
SelectThreads.ChooseThread {
    HashMap traceBacks = new HashMap();
    HashMap procedures = new HashMap();
    HashMap threads = new HashMap();
    CallerInclusive callerInclusive;
    CalleeInclusive calleeInclusive;
    LineInclusive lineInclusive;
    LineExclusive lineExclusive;
    PerfTree tree1;
    PerfTree tree2;
    PerfTree tree3;
    PerfTree tree4;
    SelectMethod selectMethod;
    SelectThreads selectThreads;
    int totalCount = 0;
    static int frameCount = 0;

    PerfAnal(String string, Reader reader) {
        super("Performance Analysis: " + string);
        Object object;
        Object object2;
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Save...");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new SaveDialog(PerfAnal.this, PerfAnal.this);
            }
        });
        jMenu.add(new JSeparator());
        jMenuItem = new JMenuItem("Exit");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        jMenu.add(jMenuItem);
        this.getContentPane().setLayout(new GridLayout(2, 2));
        LineNumberReader lineNumberReader = null;
        if (reader != null) {
            try {
                lineNumberReader = new LineNumberReader(reader);
                while ((object2 = lineNumberReader.readLine()) != null) {
                    if (((String)object2).startsWith("CPU SAMPLES BEGIN")) break;
                    if (((String)object2).startsWith("THREAD START") && ((String)object2).indexOf("name=") != -1 && (object = ThreadInfo.parse((String)object2)) != null) {
                        this.threads.put(new Integer(((ThreadInfo)object).threadNumber), object);
                    }
                    if (!((String)object2).startsWith("TRACE ") || ((String)object2).indexOf(58) == -1) continue;
                    object = TraceBack.parse((String)object2, lineNumberReader, this.threads);
                    if (object == null) {
                        throw new IOException("Cannot parse stack trace");
                    }
                    this.traceBacks.put(new Integer(((TraceBack)object).traceNumber), object);
                }
                lineNumberReader.readLine();
                while ((object2 = lineNumberReader.readLine()) != null) {
                    if (!((String)object2).startsWith("CPU SAMPLES END")) {
                        this.totalCount += Procedure.parse((String)object2, this.procedures, this.traceBacks);
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                PerfAnal.displayError("Line " + lineNumberReader.getLineNumber() + ": " + iOException, this);
            }
        }
        this.selectMethod = new SelectMethod(this, this, this.procedures);
        this.selectThreads = new SelectThreads(this, this, this.threads);
        this.callerInclusive = new CallerInclusive(this.procedures, this.totalCount);
        this.lineInclusive = new LineInclusive(this.procedures, this.totalCount);
        this.calleeInclusive = new CalleeInclusive(this.procedures, this.totalCount);
        this.lineExclusive = new LineExclusive(this.procedures, this.totalCount);
        this.tree1 = new PerfTree(this.callerInclusive, this, this);
        this.getContentPane().add(this.tree1);
        this.tree2 = new PerfTree(this.lineInclusive, this, this);
        this.getContentPane().add(this.tree2);
        this.tree3 = new PerfTree(this.calleeInclusive, this, this);
        this.getContentPane().add(this.tree3);
        this.tree4 = new PerfTree(this.lineExclusive, this, this);
        this.getContentPane().add(this.tree4);
        this.pack();
        object2 = Toolkit.getDefaultToolkit().getScreenSize();
        object = this.getSize();
        if (((Dimension)object).width > 3 * ((Dimension)object2).width / 4) {
            ((Dimension)object).width = 3 * ((Dimension)object2).width / 4;
        }
        if (((Dimension)object).height > 3 * ((Dimension)object2).height / 4) {
            ((Dimension)object).height = 3 * ((Dimension)object2).height / 4;
        }
        ((Component)this).setSize((Dimension)object);
        ((Component)this).setVisible(true);
        PerfAnal.incFrameCount();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PerfAnal.this.dispose();
                PerfAnal.decFrameCount();
            }
        });
    }

    public void chooseThread() {
        this.selectThreads.setVisible(true);
    }

    static void decFrameCount() {
        if (--frameCount == 0) {
            System.exit(0);
        }
    }

    static void displayError(String string, final JFrame jFrame) {
        final Window window = jFrame == null ? new JFrame("Error") : new JDialog(jFrame, "Error", true);
        ((RootPaneContainer)((Object)window)).getContentPane().add((Component)new JLabel(string), "Center");
        JButton jButton = new JButton("OK");
        ((RootPaneContainer)((Object)window)).getContentPane().add((Component)jButton, "South");
        ((RootPaneContainer)((Object)window)).getRootPane().setDefaultButton(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                window.dispose();
                if (jFrame == null) {
                    PerfAnal.decFrameCount();
                }
            }
        });
        window.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                window.dispose();
                if (jFrame == null) {
                    PerfAnal.decFrameCount();
                }
            }
        });
        window.pack();
        ((Component)window).setVisible(true);
        if (jFrame == null) {
            PerfAnal.incFrameCount();
        }
    }

    public void doSave(File file) {
        PrintWriter printWriter = null;
        try {
            try {
                printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
                this.tree1.saveData(printWriter);
                printWriter.println("");
                this.tree2.saveData(printWriter);
                printWriter.println("");
                this.tree3.saveData(printWriter);
                printWriter.println("");
                this.tree4.saveData(printWriter);
            }
            catch (IOException iOException) {
                PerfAnal.displayError(iOException.toString(), this);
            }
            Object var4_4 = null;
            if (printWriter != null) {
                printWriter.close();
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (printWriter != null) {
                printWriter.close();
            }
            throw throwable;
        }
    }

    public void findMethod(String string) {
        if (string == null) {
            ((Component)this.selectMethod).setVisible(true);
        } else {
            this.tree1.selectThisProc(string);
            this.tree2.selectThisProc(string);
            this.tree3.selectThisProc(string);
            this.tree4.selectThisProc(string);
        }
    }

    static void incFrameCount() {
        ++frameCount;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            new PerfAnal("stdin", new InputStreamReader(System.in));
        } else {
            int n = 0;
            while (n < stringArray.length) {
                try {
                    new PerfAnal(stringArray[n], new FileReader(stringArray[n]));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    PerfAnal.displayError(fileNotFoundException.toString(), null);
                }
                ++n;
            }
        }
    }

    public void recomputeTotals() {
        super.setEnabled(false);
        super.setCursor(Cursor.getPredefinedCursor(3));
        this.callerInclusive = new CallerInclusive(this.procedures, this.totalCount);
        this.lineInclusive = new LineInclusive(this.procedures, this.totalCount);
        this.calleeInclusive = new CalleeInclusive(this.procedures, this.totalCount);
        this.lineExclusive = new LineExclusive(this.procedures, this.totalCount);
        this.tree1.initializeRoot(this.callerInclusive);
        this.tree2.initializeRoot(this.lineInclusive);
        this.tree3.initializeRoot(this.calleeInclusive);
        this.tree4.initializeRoot(this.lineExclusive);
        this.invalidate();
        this.validate();
        super.setCursor(Cursor.getDefaultCursor());
        super.setEnabled(true);
    }
}

