/*
 * Decompiled with CFR 0.152.
 */
package com.macmillan.nmeyers;

import com.macmillan.nmeyers.SelectThreads;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.PrintWriter;
import java.util.AbstractList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

class PerfTree
extends JScrollPane {
    JTree tree = null;
    JPopupMenu popupMenu = null;
    FindMethod findMethod;
    SelectThreads.ChooseThread chooseThread;
    PerfTreeNode root;
    MouseListener mouseListener = null;

    PerfTree(PerfTreeNode perfTreeNode, FindMethod findMethod, SelectThreads.ChooseThread chooseThread) {
        this.setBorder(BorderFactory.createTitledBorder(perfTreeNode.toString()));
        this.root = perfTreeNode;
        this.findMethod = findMethod;
        this.chooseThread = chooseThread;
        this.initializeRoot(perfTreeNode);
    }

    void initializeRoot(PerfTreeNode perfTreeNode) {
        if (this.tree != null) {
            this.tree.removeMouseListener(this.mouseListener);
        }
        this.root = perfTreeNode;
        this.tree = new JTree(this.root);
        this.tree.setLargeModel(true);
        this.tree.setRootVisible(false);
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.popupMenu.add(new AbstractAction("Goto this Method"){

                public void actionPerformed(ActionEvent actionEvent) {
                    PerfTreeNode perfTreeNode = (PerfTreeNode)PerfTree.this.tree.getSelectionPath().getLastPathComponent();
                    PerfTree.this.findMethod.findMethod(perfTreeNode.getProcName());
                }
            });
            this.popupMenu.add(new AbstractAction("Select a Method to Analyze"){

                public void actionPerformed(ActionEvent actionEvent) {
                    PerfTree.this.findMethod.findMethod(null);
                }
            });
            this.popupMenu.add(new AbstractAction("Select Thread(s) to Analyze"){

                public void actionPerformed(ActionEvent actionEvent) {
                    PerfTree.this.chooseThread.chooseThread();
                }
            });
        }
        this.popupMenu.setInvoker(this.tree);
        if (this.mouseListener == null) {
            this.mouseListener = new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    int n;
                    int n2;
                    int n3;
                    if (mouseEvent.isPopupTrigger() && (n3 = PerfTree.this.tree.getRowForLocation(n2 = mouseEvent.getX(), n = mouseEvent.getY())) != -1) {
                        PerfTree.this.tree.setSelectionRow(n3);
                        PerfTree.this.popupMenu.show(PerfTree.this.tree, n2, n);
                    }
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    int n;
                    int n2;
                    int n3;
                    if (mouseEvent.isPopupTrigger() && (n3 = PerfTree.this.tree.getRowForLocation(n2 = mouseEvent.getX(), n = mouseEvent.getY())) != -1) {
                        PerfTree.this.tree.setSelectionRow(n3);
                        PerfTree.this.popupMenu.show(PerfTree.this.tree, n2, n);
                    }
                }
            };
        }
        this.tree.addMouseListener(this.mouseListener);
        this.setViewportView(this.tree);
    }

    void saveData(PrintWriter printWriter) {
        this.root.saveData(printWriter);
    }

    void selectThisProc(String string) {
        if (string == null) {
            return;
        }
        TreePath treePath = this.root.findThisProc(string);
        if (treePath != null) {
            this.tree.setSelectionPath(treePath);
            this.tree.scrollPathToVisible(treePath);
        }
    }

    static abstract class PerfTreeNode
    extends DefaultMutableTreeNode {
        PerfTreeNode(Object object) {
            super(object);
        }

        abstract TreePath findThisProc(String var1);

        abstract String getProcName();

        void saveData(PrintWriter printWriter) {
            int n = this.getLevel();
            int n2 = 0;
            while (n2 < n) {
                printWriter.print("  ");
                ++n2;
            }
            if (n > 0) {
                printWriter.print(n + ": ");
            }
            printWriter.println(this.toString());
            if (this.children != null) {
                Iterator iterator = ((AbstractList)this.children).iterator();
                while (iterator.hasNext()) {
                    ((PerfTreeNode)iterator.next()).saveData(printWriter);
                }
            }
        }
    }

    static interface FindMethod {
        public void findMethod(String var1);
    }
}

