/*
 * Decompiled with CFR 0.152.
 */
package com.macmillan.nmeyers;

import com.macmillan.nmeyers.ThreadInfo;
import com.macmillan.nmeyers.TraceBack;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.TreeSet;

class Procedure
implements Comparable {
    public String procName;
    public int countInclusive = 0;
    public int countExclusive = 0;
    TreeSet lines = new TreeSet();
    LinkedList myTraces = new LinkedList();

    Procedure(String string) {
        this.procName = string;
    }

    public int compareTo(Object object) {
        return this.procName.compareTo(((Procedure)object).procName);
    }

    public boolean equals(Object object) {
        return this.procName.equals(((Procedure)object).procName);
    }

    public static Procedure factory(String string, HashMap hashMap) {
        Procedure procedure = (Procedure)hashMap.get(string);
        if (procedure != null) {
            return procedure;
        }
        procedure = new Procedure(string);
        hashMap.put(string, procedure);
        return procedure;
    }

    public static int parse(String string, HashMap hashMap, HashMap hashMap2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        int n = Integer.parseInt(stringTokenizer.nextToken());
        Integer n2 = new Integer(stringTokenizer.nextToken());
        TraceBack traceBack = (TraceBack)hashMap2.get(n2);
        traceBack.traceCount = n;
        if (traceBack.thread != null) {
            traceBack.thread.count += n;
        }
        if (traceBack != null && !traceBack.entries.isEmpty()) {
            int n3 = 0;
            Iterator iterator = traceBack.entries.iterator();
            TreeSet<Procedure> treeSet = new TreeSet<Procedure>();
            TreeSet<Procedure> treeSet2 = new TreeSet<Procedure>();
            while (iterator.hasNext()) {
                TraceBack.TraceBackEntry traceBackEntry = (TraceBack.TraceBackEntry)iterator.next();
                Procedure procedure = Procedure.factory(traceBackEntry.procName, hashMap);
                Line line = Line.factory(traceBackEntry.procLineNum, procedure.lines, traceBack.thread);
                if (treeSet.add(procedure)) {
                    procedure.countInclusive += n;
                }
                if (treeSet2.add(procedure)) {
                    line.countInclusive += n;
                }
                if (n3 == 0) {
                    procedure.countExclusive += n;
                    line.countExclusive += n;
                }
                procedure.myTraces.add(new TraceInfo(traceBack, n3));
                ++n3;
            }
        }
        return n;
    }

    public String toString() {
        return this.procName;
    }

    static class TraceInfo {
        public TraceBack traceBack;
        public int depth;

        TraceInfo(TraceBack traceBack, int n) {
            this.traceBack = traceBack;
            this.depth = n;
        }

        public String toString() {
            return "[traceBack=" + this.traceBack + ",depth=" + this.depth + ']';
        }
    }

    static class Line
    implements Comparable {
        public String lineInfo;
        public int countInclusive = 0;
        public int countExclusive = 0;
        public ThreadInfo thread = null;

        private Line(String string, ThreadInfo threadInfo) {
            this.lineInfo = string;
            this.thread = threadInfo;
        }

        public int compareTo(Object object) {
            int n = this.lineInfo.compareTo(((Line)object).lineInfo);
            if (n == 0 && this.thread != null) {
                n = this.thread.compareTo(((Line)object).thread);
            }
            return n;
        }

        public boolean equals(Object object) {
            return this.lineInfo.equals(((Line)object).lineInfo) && (this.thread == null || this.thread.equals(((Line)object).thread));
        }

        public static Line factory(String string, TreeSet treeSet, ThreadInfo threadInfo) {
            Line line = new Line(string, threadInfo);
            if (treeSet.add(line)) {
                return line;
            }
            return treeSet.tailSet(line).first();
        }

        public String toString() {
            return "[lineInfo=" + this.lineInfo + ",countInclusive=" + this.countInclusive + ",countExclusive=" + this.countExclusive + ",thread=" + this.thread + ']';
        }
    }
}

